/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simpleflatmapper.reflect.BuilderInstantiatorDefinition;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.reflect.setter.SetterHelper;
import org.simpleflatmapper.util.ConstantPredicate;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;

public class BuilderInstantiatorDefinitionFactory {
    public static final Predicate<Method> GOOGLE_PROTO_EXCLUDE = new Predicate<Method>(){
        Set<String> excludeMethod = new HashSet<String>(Arrays.asList("setUnknownFields", "clearField", "mergeUnknownFields", "mergeFrom", "clearOneof", "mergeFrom", "parseFrom", "parseDelimitedFrom", "parsePartialFrom", "newBuilderForField", "getField", "getFieldBuilder"));

        public boolean test(Method method) {
            String name = method.getName();
            return this.excludeMethod.contains(name);
        }
    };

    public static List<InstantiatorDefinition> extractDefinitions(Type target) {
        ArrayList<InstantiatorDefinition> instantiatorDefinitions = new ArrayList<InstantiatorDefinition>();
        Class clazz = TypeHelper.toClass((Type)target);
        for (Method m : clazz.getDeclaredMethods()) {
            BuilderInstantiatorDefinition def;
            if (!BuilderInstantiatorDefinitionFactory.isPotentialBuilderMethod(m) || (def = BuilderInstantiatorDefinitionFactory.getDefinitionForBuilderFromMethod(m, target)) == null) continue;
            instantiatorDefinitions.add(def);
        }
        return instantiatorDefinitions;
    }

    private static boolean isPotentialBuilderMethod(Method m) {
        return Modifier.isStatic(m.getModifiers()) && m.getParameterTypes().length == 0 && !Void.TYPE.equals(m.getReturnType()) && !TypeHelper.areEquals(m.getReturnType(), m.getDeclaringClass());
    }

    private static BuilderInstantiatorDefinition getDefinitionForBuilderFromMethod(Method m, Type target) {
        if (Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers()) && m.getParameterTypes().length == 0 && !Void.TYPE.equals(m.getReturnType())) {
            return BuilderInstantiatorDefinitionFactory.getDefinitionForBuilder(m, target);
        }
        return null;
    }

    public static BuilderInstantiatorDefinition getDefinitionForBuilder(Member e, Type target) {
        ExecutableInstantiatorDefinition def = new ExecutableInstantiatorDefinition(e, new Parameter[0]);
        Type builderType = e instanceof Constructor ? ((Constructor)e).getDeclaringClass() : ((Method)e).getGenericReturnType();
        return BuilderInstantiatorDefinitionFactory.getDefinitionForBuilder(def, builderType, target);
    }

    private static BuilderInstantiatorDefinition getDefinitionForBuilder(ExecutableInstantiatorDefinition def, Type builderType, Type target) {
        HashMap<Parameter, Method> setters = new HashMap<Parameter, Method>();
        ArrayList<Method> buildMethods = new ArrayList<Method>();
        int i = 0;
        Class builderClass = TypeHelper.toClass((Type)builderType);
        if (BuilderInstantiatorDefinitionFactory.ignoreBuilderClass(builderClass)) {
            return null;
        }
        Predicate<Method> excludeMethod = BuilderInstantiatorDefinitionFactory.getExcludeMethodPredicateFor(builderClass);
        for (Method m : builderClass.getMethods()) {
            if (excludeMethod.test((Object)m) || Modifier.isStatic(m.getModifiers()) || Object.class == m.getDeclaringClass()) continue;
            Type returnType = m.getGenericReturnType();
            if ((TypeHelper.areEquals((Type)returnType, Void.TYPE) || TypeHelper.isAssignable((Type)returnType, (Type)builderType)) && m.getParameterTypes().length == 1) {
                Parameter p = new Parameter(i++, SetterHelper.getPropertyNameFromBuilderMethodName(m.getName()), m.getParameterTypes()[0], m.getGenericParameterTypes()[0]);
                setters.put(p, m);
                continue;
            }
            if (!TypeHelper.isAssignable((Type)target, (Type)returnType) || m.getParameterTypes().length != 0) continue;
            buildMethods.add(m);
        }
        Method buildMethod = BuilderInstantiatorDefinitionFactory.selectBuildMethod(buildMethods);
        if (!setters.isEmpty() && buildMethod != null) {
            return new BuilderInstantiatorDefinition(def, setters, buildMethod);
        }
        return null;
    }

    private static boolean ignoreBuilderClass(Class<?> builderClass) {
        return "com.google.protobuf.Parser".equals(builderClass.getName());
    }

    private static Predicate<Method> getExcludeMethodPredicateFor(Class<?> builderClass) {
        if (builderClass.getSuperclass() != null && builderClass.getSuperclass().getName().equals("com.google.protobuf.GeneratedMessageV3$Builder")) {
            return GOOGLE_PROTO_EXCLUDE;
        }
        return ConstantPredicate.falsePredicate();
    }

    private static Method selectBuildMethod(List<Method> buildMethods) {
        if (buildMethods.isEmpty()) {
            return null;
        }
        if (buildMethods.size() == 1) {
            return buildMethods.get(0);
        }
        for (Method m : buildMethods) {
            if (!m.getName().equals("build")) continue;
            return m;
        }
        throw new IllegalStateException("Multiple potential build methods candidate " + buildMethods + ", cannot use the builder on that object");
    }
}

