/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.util.Iterator;
import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.map.EnumerableMapper;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.Enumerable;
import org.simpleflatmapper.util.EnumerableIterator;

public abstract class AbstractEnumerableMapper<SET, T, E extends Exception>
implements EnumerableMapper<SET, T, E> {
    protected final ConsumerErrorHandler errorHandler;

    public AbstractEnumerableMapper(ConsumerErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public final <H extends CheckedConsumer<? super T>> H forEach(SET source, H handler) throws E, MappingException {
        Enumerable enumerable = this.enumerate(source);
        while (enumerable.next()) {
            Object t = enumerable.currentValue();
            this.handleT(handler, t);
        }
        return handler;
    }

    private <H extends CheckedConsumer<? super T>> void handleT(H handler, T t) {
        try {
            handler.accept(t);
        }
        catch (Throwable e) {
            this.errorHandler.handlerError(e, t);
        }
    }

    @Override
    public final Iterator<T> iterator(SET source) throws MappingException, E {
        return new EnumerableIterator(this.enumerate(source));
    }
}

