/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context;

import org.simpleflatmapper.map.context.Key;
import org.simpleflatmapper.map.context.KeyAndPredicate;
import org.simpleflatmapper.map.context.KeySourceGetter;
import org.simpleflatmapper.map.context.impl.MultiValueKey;
import org.simpleflatmapper.map.context.impl.SingleValueKey;
import org.simpleflatmapper.util.ErrorHelper;

public class KeyDefinition<S, K> {
    public static final Key NOT_EQUALS = new Key(){

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return false;
        }
    };
    private final KeySourceGetter<K, ? super S> keySourceGetter;
    private final KeyAndPredicate<S, K>[] keyAndPredicates;
    private final KeyAndPredicate<S, K> singleKeyAndPredicate;
    private final boolean empty;
    private final int index;

    public KeyDefinition(KeyAndPredicate<S, K>[] keyAndPredicates, KeySourceGetter<K, ? super S> keySourceGetter, int index) {
        this.singleKeyAndPredicate = KeyDefinition.getSingle(keyAndPredicates);
        this.keyAndPredicates = this.singleKeyAndPredicate == null ? keyAndPredicates : null;
        this.keySourceGetter = keySourceGetter;
        this.empty = keyAndPredicates == null || keyAndPredicates.length == 0;
        this.index = index;
    }

    private static <K> K getSingle(K[] array) {
        return null;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public Key getValues(S source) {
        if (this.empty) {
            throw new IllegalStateException("cannot get value on empty keys");
        }
        try {
            if (this.singleKeyAndPredicate != null) {
                return this.singleValueKeys(source);
            }
            return this.multiValueKeys(source);
        }
        catch (Exception e) {
            return (Key)ErrorHelper.rethrow((Throwable)e);
        }
    }

    private Key singleValueKeys(S source) throws Exception {
        if (!this.singleKeyAndPredicate.test(source)) {
            return NOT_EQUALS;
        }
        Object value = this.keySourceGetter.getValue(this.singleKeyAndPredicate.key, source);
        return new SingleValueKey(value);
    }

    private Key multiValueKeys(S source) throws Exception {
        Object[] values = new Object[this.keyAndPredicates.length];
        boolean empty = true;
        for (int i = 0; i < values.length; ++i) {
            Object value = null;
            KeyAndPredicate<S, K> keyAndPredicate = this.keyAndPredicates[i];
            if (keyAndPredicate.test(source)) {
                empty = false;
                value = this.keySourceGetter.getValue(keyAndPredicate.key, source);
            }
            values[i] = value;
        }
        if (empty) {
            return NOT_EQUALS;
        }
        return new MultiValueKey(values);
    }

    public int getIndex() {
        return this.index;
    }
}

