/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import org.simpleflatmapper.converter.ComposedContextualConverter;
import org.simpleflatmapper.converter.ContextFactoryBuilder;
import org.simpleflatmapper.converter.ContextualConverter;
import org.simpleflatmapper.converter.ContextualConverterFactory;
import org.simpleflatmapper.converter.ContextualConverterFactoryAdapter;
import org.simpleflatmapper.converter.ContextualConverterFactoryProducer;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.ConverterFactory;
import org.simpleflatmapper.converter.ConverterFactoryProducer;
import org.simpleflatmapper.converter.ConverterToContextualAdapter;
import org.simpleflatmapper.converter.ConvertingScore;
import org.simpleflatmapper.converter.ConvertingTypes;
import org.simpleflatmapper.converter.DefaultContextFactoryBuilder;
import org.simpleflatmapper.converter.impl.IdentityConverter;
import org.simpleflatmapper.converter.impl.JavaBaseConverterFactoryProducer;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ProducerServiceLoader;
import org.simpleflatmapper.util.TypeHelper;

public class ConverterService {
    private static final ConverterService INSTANCE = new ConverterService(ConverterService.getConverterFactories(ConverterService.class.getClassLoader()));
    private final List<ContextualConverterFactory> converters;

    private static List<ContextualConverterFactory> getConverterFactories(ClassLoader classLoader) {
        final ArrayList<ContextualConverterFactory> converterFactories = new ArrayList<ContextualConverterFactory>();
        final Consumer factoryConsumer = new Consumer<ContextualConverterFactory<?, ?>>(){

            public void accept(ContextualConverterFactory<?, ?> converterFactory) {
                converterFactories.add(converterFactory);
            }
        };
        new JavaBaseConverterFactoryProducer().produce(factoryConsumer);
        ProducerServiceLoader.produceFromServiceLoader(ServiceLoader.load(ContextualConverterFactoryProducer.class, classLoader), (Consumer)factoryConsumer);
        ProducerServiceLoader.produceFromServiceLoader(ServiceLoader.load(ConverterFactoryProducer.class, classLoader), (Consumer)new Consumer<ConverterFactory<?, ?>>(){

            public void accept(ConverterFactory<?, ?> converterFactory) {
                factoryConsumer.accept(new ContextualConverterFactoryAdapter(converterFactory));
            }
        });
        return converterFactories;
    }

    public static ConverterService getInstance() {
        return INSTANCE;
    }

    public static ConverterService getInstance(ClassLoader classLoader) {
        return new ConverterService(ConverterService.getConverterFactories(classLoader));
    }

    private ConverterService(List<ContextualConverterFactory> converters) {
        this.converters = converters;
    }

    public <F, P> Converter<? super F, ? extends P> findConverter(Class<F> inType, Class<P> outType, Object ... params) {
        return this.findConverter((Type)inType, (Type)outType, params);
    }

    public <F, P> Converter<? super F, ? extends P> findConverter(Type inType, Type outType, Object ... params) {
        DefaultContextFactoryBuilder builder = new DefaultContextFactoryBuilder();
        ContextualConverter<F, P> converter = this.findConverter(inType, outType, (ContextFactoryBuilder)builder, params);
        if (converter == null) {
            return null;
        }
        return new ConverterToContextualAdapter<F, P>(converter, builder.build());
    }

    public <F, P> ContextualConverter<? super F, ? extends P> findConverter(Class<F> inType, Class<P> outType, ContextFactoryBuilder contextFactoryBuilder, Object ... params) {
        return this.findConverter((Type)inType, (Type)outType, contextFactoryBuilder, params);
    }

    public <F, P> ContextualConverter<? super F, ? extends P> findConverter(Type inType, Type outType, ContextFactoryBuilder contextFactoryBuilder, Object ... params) {
        if (TypeHelper.isAssignable((Type)outType, (Type)inType)) {
            return new IdentityConverter();
        }
        List<ScoredConverterFactory> potentials = this.findConverterFactories(inType, outType, params);
        ConvertingTypes targetedTypes = new ConvertingTypes(inType, outType);
        for (ScoredConverterFactory p : potentials) {
            ContextualConverter converter = p.converterFactory.newConverter(targetedTypes, contextFactoryBuilder, params);
            if (converter == null) continue;
            return converter;
        }
        return null;
    }

    public List<ScoredConverterFactory> findConverterFactories(Type inType, Type outType, Object ... params) {
        return this.findConverterFactories(inType, outType, params, new HashSet<Type>());
    }

    private List<ScoredConverterFactory> findConverterFactories(Type inType, Type outType, Object[] params, Set<Type> loopDetector) {
        ArrayList<ScoredConverterFactory> potentials = new ArrayList<ScoredConverterFactory>();
        ArrayList<ScoredConverterFactory> tails = new ArrayList<ScoredConverterFactory>();
        ConvertingTypes targetedTypes = new ConvertingTypes(inType, outType);
        for (ContextualConverterFactory converterFactory : this.converters) {
            ConvertingScore score = converterFactory.score(targetedTypes);
            int globalScore = score.getScore();
            if (globalScore >= 0) {
                potentials.add(new ScoredConverterFactory(globalScore, converterFactory));
                continue;
            }
            int tailScore = score.getToScore();
            if (tailScore < 0) continue;
            tails.add(new ScoredConverterFactory(tailScore, converterFactory));
        }
        if (potentials.isEmpty() && tails.size() > 0) {
            Collections.sort(tails);
            int currentScore = Integer.MIN_VALUE;
            block3: for (ScoredConverterFactory sfactory : tails) {
                List<ScoredConverterFactory> tailConverters;
                Type tailFactoryInType;
                if (!potentials.isEmpty() && currentScore != Integer.MIN_VALUE) {
                    if (currentScore > sfactory.score) {
                        return potentials;
                    }
                } else {
                    currentScore = sfactory.score;
                }
                if (outType == (tailFactoryInType = sfactory.converterFactory.getFromType()) || loopDetector.contains(tailFactoryInType)) continue;
                HashSet<Type> subLoopDetectors = new HashSet<Type>(loopDetector);
                subLoopDetectors.add(tailFactoryInType);
                List<ScoredConverterFactory> headConverters = this.findConverterFactories(inType, tailFactoryInType, params, subLoopDetectors);
                if (headConverters.isEmpty() || (tailConverters = this.findConverterFactories(tailFactoryInType, outType, params, subLoopDetectors)).isEmpty()) continue;
                for (ScoredConverterFactory hf : headConverters) {
                    try {
                        if (hf.converterFactory.newConverter(new ConvertingTypes(inType, tailFactoryInType), new DefaultContextFactoryBuilder(), params) == null) continue;
                        for (ScoredConverterFactory tf : tailConverters) {
                            if (hf.converterFactory.newConverter(new ConvertingTypes(tailFactoryInType, outType), new DefaultContextFactoryBuilder(), params) == null) continue;
                            ComposedConverterFactory composedConverterFactory = new ComposedConverterFactory(hf.converterFactory, tf.converterFactory, tailFactoryInType);
                            int score = composedConverterFactory.score(new ConvertingTypes(inType, outType)).getScore();
                            potentials.add(new ScoredConverterFactory(score, composedConverterFactory));
                            continue block3;
                        }
                        continue block3;
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                }
            }
        }
        Collections.sort(potentials);
        return potentials;
    }

    private static class ComposedConverterFactory<I, T, O>
    implements ContextualConverterFactory<I, O> {
        private final ContextualConverterFactory<I, T> headConverterFactory;
        private final ContextualConverterFactory<T, O> tailConverterFactory;
        private final Type tType;

        private ComposedConverterFactory(ContextualConverterFactory<I, T> headConverterFactory, ContextualConverterFactory<T, O> tailConverterFactory, Type tType) {
            this.headConverterFactory = headConverterFactory;
            this.tailConverterFactory = tailConverterFactory;
            this.tType = tType;
        }

        @Override
        public ContextualConverter<? super I, ? extends O> newConverter(ConvertingTypes targetedTypes, ContextFactoryBuilder contextFactoryBuilder, Object ... params) {
            ContextualConverter<I, T> head = this.headConverterFactory.newConverter(new ConvertingTypes(targetedTypes.getFrom(), this.tType), contextFactoryBuilder, params);
            if (head == null) {
                return null;
            }
            ContextualConverter<T, O> tail = this.tailConverterFactory.newConverter(new ConvertingTypes(this.tType, targetedTypes.getTo()), contextFactoryBuilder, new Object[0]);
            if (tail == null) {
                return null;
            }
            return new ComposedContextualConverter<I, T, O>(head, tail);
        }

        @Override
        public ConvertingScore score(ConvertingTypes targetedTypes) {
            ConvertingScore headScore = this.headConverterFactory.score(new ConvertingTypes(targetedTypes.getFrom(), this.tType));
            ConvertingScore tailScore = this.tailConverterFactory.score(new ConvertingTypes(this.tType, targetedTypes.getTo()));
            return new ConvertingScore(Math.min(headScore.getFromScore(), tailScore.getFromScore()), Math.min(headScore.getToScore(), tailScore.getToScore()));
        }

        @Override
        public Type getFromType() {
            return this.headConverterFactory.getFromType();
        }
    }

    private static class ScoredConverterFactory
    implements Comparable<ScoredConverterFactory> {
        private final int score;
        private final ContextualConverterFactory converterFactory;

        private ScoredConverterFactory(int score, ContextualConverterFactory converterFactory) {
            this.score = score;
            this.converterFactory = converterFactory;
        }

        @Override
        public int compareTo(ScoredConverterFactory o) {
            return o.score - this.score;
        }
    }
}

