/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URL;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.shredzone.acme4j.AcmeResource;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeLazyLoadingException;
import org.shredzone.acme4j.exception.AcmeRetryAfterException;
import org.shredzone.acme4j.toolbox.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AcmeJsonResource
extends AcmeResource {
    private static final long serialVersionUID = -5060364275766082345L;
    private static final Logger LOG = LoggerFactory.getLogger(AcmeJsonResource.class);
    @Nullable
    private JSON data = null;
    @Nullable
    private Instant retryAfter = null;

    protected AcmeJsonResource(Login login, URL location) {
        super(login, location);
    }

    public JSON getJSON() {
        if (this.data == null) {
            try {
                this.fetch();
            }
            catch (AcmeException ex) {
                throw new AcmeLazyLoadingException(this, ex);
            }
        }
        return Objects.requireNonNull(this.data);
    }

    protected void setJSON(JSON data) {
        this.invalidate();
        this.data = Objects.requireNonNull(data, "data");
    }

    protected boolean isValid() {
        return this.data != null;
    }

    protected void invalidate() {
        this.data = null;
        this.retryAfter = null;
    }

    @Deprecated
    public void update() throws AcmeException {
        Optional<Instant> retryAfter = this.fetch();
        if (retryAfter.isPresent()) {
            throw new AcmeRetryAfterException(this.getClass().getSimpleName() + " is not completed yet", retryAfter.get());
        }
    }

    public Optional<Instant> fetch() throws AcmeException {
        String resourceType = this.getClass().getSimpleName();
        LOG.debug("update {}", (Object)resourceType);
        Connection conn = this.getSession().connect();
        try {
            conn.sendSignedPostAsGetRequest(this.getLocation(), this.getLogin());
            this.setJSON(conn.readJsonResponse());
            Optional<Instant> retryAfterOpt = conn.getRetryAfter();
            retryAfterOpt.ifPresent(instant -> LOG.debug("Retry-After: {}", instant));
            this.setRetryAfter(retryAfterOpt.orElse(null));
            Optional<Instant> optional = retryAfterOpt;
            if (conn != null) {
                conn.close();
            }
            return optional;
        }
        catch (Throwable throwable) {
            try {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (AcmeRetryAfterException ex) {
                LOG.debug("Retry-After while attempting to read the resource", (Throwable)ex);
                this.setRetryAfter(ex.getRetryAfter());
                return Optional.of(ex.getRetryAfter());
            }
        }
    }

    protected void setRetryAfter(@Nullable Instant retryAfter) {
        this.retryAfter = retryAfter;
    }

    public Optional<Instant> getRetryAfter() {
        return Optional.ofNullable(this.retryAfter);
    }
}

