/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rdf2go;

import info.aduna.iteration.CloseableIteration;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Statement;
import org.openrdf.rdf2go.RepositoryModel;
import org.openrdf.rdf2go.StatementWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementIterator
implements ClosableIterator<org.ontoware.rdf2go.model.Statement> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CloseableIteration<? extends Statement, ? extends OpenRDFException> cit;
    private boolean closed = false;
    private RepositoryModel model;

    public StatementIterator(CloseableIteration<? extends Statement, ? extends OpenRDFException> cit, RepositoryModel model) {
        this.cit = cit;
        this.model = model;
    }

    public boolean hasNext() {
        boolean hasNext;
        if (this.closed) {
            return false;
        }
        try {
            hasNext = this.cit.hasNext();
        }
        catch (OpenRDFException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    public org.ontoware.rdf2go.model.Statement next() {
        StatementWrapper result = null;
        try {
            Statement nextStatement = (Statement)this.cit.next();
            result = new StatementWrapper(this.model, nextStatement);
            if (!this.cit.hasNext()) {
                this.close();
            }
        }
        catch (OpenRDFException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void close() {
        try {
            this.cit.close();
        }
        catch (OpenRDFException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                this.logger.warn(this.getClass().getName() + " not closed, closing now");
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

