/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rdf2go;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.Iteration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ontoware.aifbcommons.collection.ClosableIterable;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.exception.QueryLanguageNotSupportedException;
import org.ontoware.rdf2go.model.DiffReader;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.ModelSet;
import org.ontoware.rdf2go.model.QuadPattern;
import org.ontoware.rdf2go.model.QueryResultTable;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.impl.AbstractModelSetImpl;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryLanguage;
import org.openrdf.rdf2go.ConversionUtil;
import org.openrdf.rdf2go.GraphIterable;
import org.openrdf.rdf2go.RepositoryModel;
import org.openrdf.rdf2go.RepositoryQueryResultTable;
import org.openrdf.rdf2go.StatementIterable;
import org.openrdf.rdf2go.StatementWrapper;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryModelSet
extends AbstractModelSetImpl {
    private static Logger log = LoggerFactory.getLogger(RepositoryModelSet.class);
    private RepositoryConnection connection;
    private Repository repository;
    private ValueFactory valueFactory;

    public RepositoryModelSet(Repository repository) throws ModelRuntimeException {
        this.init(repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Iterator<? extends org.ontoware.rdf2go.model.Statement> iterator) throws ModelRuntimeException {
        if (this.isLocked()) {
            throw new ModelRuntimeException("Model is locked, cannot perform an update.");
        }
        this.assertModel();
        try {
            boolean autocommitBefore = this.connection.isAutoCommit();
            this.connection.setAutoCommit(false);
            try {
                try {
                    while (iterator.hasNext()) {
                        org.ontoware.rdf2go.model.Statement s = iterator.next();
                        org.openrdf.model.URI context = ConversionUtil.toOpenRDF(s.getContext(), this.valueFactory);
                        Statement sd = ConversionUtil.toOpenRDF(s, this.valueFactory);
                        this.connection.add(sd, new Resource[]{context});
                    }
                    this.connection.commit();
                }
                catch (RepositoryException x) {
                    this.connection.rollback();
                }
            }
            finally {
                this.connection.setAutoCommit(autocommitBefore);
            }
        }
        catch (RepositoryException x) {
            throw new ModelRuntimeException((Throwable)x);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addModel(Model model) throws ModelRuntimeException {
        this.assertModel();
        if (!(model instanceof RepositoryModel)) return super.addModel(model);
        RepositoryModel repositoryModel = (RepositoryModel)model;
        if (repositoryModel.repository == this.repository) {
            return true;
        }
        org.openrdf.model.URI context = repositoryModel.getOpenRDFContextURI();
        RepositoryResult statements = null;
        try {
            statements = repositoryModel.connection.getStatements(null, null, null, false, new Resource[]{context});
            this.connection.add((Iteration)statements, new Resource[]{context});
            return true;
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        finally {
            if (statements != null) {
                try {
                    statements.close();
                }
                catch (RepositoryException e) {
                    throw new ModelRuntimeException((Throwable)e);
                }
            }
        }
    }

    public void addModel(Model model, URI contextURI) throws ModelRuntimeException {
        this.assertModel();
        if (model instanceof RepositoryModel) {
            RepositoryModel repositoryModel = (RepositoryModel)model;
            org.openrdf.model.URI openrdfContextURI = ConversionUtil.toOpenRDF(contextURI, this.valueFactory);
            if (repositoryModel.repository == this.repository) {
                try {
                    RepositoryResult statements = repositoryModel.connection.getStatements(null, null, null, true, new Resource[0]);
                    HashSet<Statement> stmts = new HashSet<Statement>();
                    for (Statement stmt : statements.asList()) {
                        stmts.add(stmt);
                    }
                    for (Statement stmt : stmts) {
                        this.valueFactory.createStatement(stmt.getSubject(), stmt.getPredicate(), stmt.getObject(), (Resource)openrdfContextURI);
                    }
                }
                catch (RepositoryException e) {
                    throw new ModelRuntimeException((Throwable)e);
                }
            }
            org.openrdf.model.URI context = repositoryModel.getOpenRDFContextURI();
            RepositoryResult statements = null;
            try {
                statements = repositoryModel.connection.getStatements(null, null, null, false, new Resource[]{context});
                for (Statement stmt : statements.asList()) {
                    this.connection.add(this.valueFactory.createStatement(stmt.getSubject(), stmt.getPredicate(), stmt.getObject(), (Resource)openrdfContextURI), new Resource[]{openrdfContextURI});
                }
            }
            catch (RepositoryException e) {
                throw new ModelRuntimeException((Throwable)e);
            }
            finally {
                if (statements != null) {
                    try {
                        statements.close();
                    }
                    catch (RepositoryException e) {
                        throw new ModelRuntimeException((Throwable)e);
                    }
                }
            }
        }
        super.addModel(model, contextURI);
    }

    public void addModelSet(ModelSet modelSet) throws ModelRuntimeException {
        this.assertModel();
        if (modelSet instanceof RepositoryModel) {
            RepositoryModel repositoryModel = (RepositoryModel)modelSet;
            if (repositoryModel.repository != this.repository) {
                RepositoryResult statements = null;
                try {
                    statements = repositoryModel.connection.getStatements(null, null, null, false, new Resource[0]);
                    this.connection.add((Iteration)statements, new Resource[0]);
                }
                catch (RepositoryException e) {
                    throw new ModelRuntimeException((Throwable)e);
                }
                finally {
                    if (statements != null) {
                        try {
                            statements.close();
                        }
                        catch (RepositoryException e) {
                            throw new ModelRuntimeException((Throwable)e);
                        }
                    }
                }
            }
        } else {
            super.addModelSet(modelSet);
        }
    }

    public void addStatement(org.ontoware.rdf2go.model.Statement statement) throws ModelRuntimeException {
        this.assertModel();
        try {
            Statement s = ConversionUtil.toOpenRDF(statement, this.valueFactory);
            this.connection.add(s, new Resource[]{s.getContext()});
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void close() {
        if (this.isOpen()) {
            try {
                this.connection.close();
            }
            catch (RepositoryException e) {
                throw new ModelRuntimeException((Throwable)e);
            }
            finally {
                this.connection = null;
            }
        }
    }

    public void commit() {
        try {
            this.connection.commit();
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public boolean contains(org.ontoware.rdf2go.model.Statement s) throws ModelRuntimeException {
        return this.containsStatements((UriOrVariable)s.getContext(), (ResourceOrVariable)s.getSubject(), (UriOrVariable)s.getPredicate(), (NodeOrVariable)s.getObject());
    }

    public boolean containsModel(URI contextURI) {
        try {
            return this.connection.hasStatement(null, null, null, false, new Resource[]{ConversionUtil.toOpenRDF(contextURI, this.repository.getValueFactory())});
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsStatements(UriOrVariable contextURI, ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) throws ModelRuntimeException {
        this.assertModel();
        ClosableIterator<org.ontoware.rdf2go.model.Statement> i = this.findStatements(contextURI, subject, predicate, object);
        try {
            boolean bl = i.hasNext();
            return bl;
        }
        finally {
            i.close();
        }
    }

    public QuadPattern createQuadPattern(UriOrVariable context, ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) {
        return new OpenRDFQuadPattern(context, subject, predicate, object);
    }

    public URI createURI(String uriString) throws ModelRuntimeException {
        try {
            this.valueFactory.createURI(uriString);
        }
        catch (IllegalArgumentException e) {
            throw new ModelRuntimeException("Wrong URI format for Sesame", (Throwable)e);
        }
        return new URIImpl(uriString, false);
    }

    public void dump() {
        this.assertModel();
        try {
            this.writeTo(System.out, Syntax.RdfXml);
        }
        catch (IOException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public ClosableIterator<org.ontoware.rdf2go.model.Statement> findStatements(QuadPattern pattern) throws ModelRuntimeException {
        return this.findStatements(pattern.getContext(), pattern.getSubject(), pattern.getPredicate(), pattern.getObject());
    }

    public ClosableIterator<org.ontoware.rdf2go.model.Statement> findStatements(UriOrVariable contextURI, ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) throws ModelRuntimeException {
        this.assertModel();
        Resource sesameSubject = (Resource)ConversionUtil.toOpenRDF(subject, this.valueFactory);
        org.openrdf.model.URI sesamePredicate = (org.openrdf.model.URI)ConversionUtil.toOpenRDF(predicate, this.valueFactory);
        Value sesameObject = ConversionUtil.toOpenRDF(object, this.valueFactory);
        org.openrdf.model.URI sesameContext = (org.openrdf.model.URI)ConversionUtil.toOpenRDF(contextURI, this.valueFactory);
        try {
            RepositoryResult statements = contextURI != null && !contextURI.equals(Variable.ANY) ? this.connection.getStatements(sesameSubject, sesamePredicate, sesameObject, true, new Resource[]{sesameContext}) : this.connection.getStatements(sesameSubject, sesamePredicate, sesameObject, true, new Resource[0]);
            return new StatementIterator((RepositoryResult<Statement>)statements);
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public Model getDefaultModel() {
        RepositoryModel model = new RepositoryModel(this.repository);
        model.open();
        return model;
    }

    public Model getModel(URI contextURI) {
        RepositoryModel model = new RepositoryModel(contextURI, this.repository);
        model.open();
        return model;
    }

    public ClosableIterator<Model> getModels() {
        this.assertModel();
        return new ModelIterator(this.getModelURIs());
    }

    public ClosableIterator<URI> getModelURIs() {
        this.assertModel();
        try {
            return new ContextIterator((RepositoryResult<Resource>)this.connection.getContextIDs());
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public String getNamespace(String prefix) {
        this.assertModel();
        try {
            return this.connection.getNamespace(prefix);
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public Map<String, String> getNamespaces() {
        this.assertModel();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        try {
            RepositoryResult openrdfMap = this.connection.getNamespaces();
            openrdfMap.enableDuplicateFilter();
            List openrdfList = openrdfMap.asList();
            for (Namespace openrdfNamespace : openrdfList) {
                nsMap.put(openrdfNamespace.getPrefix(), openrdfNamespace.getName());
            }
            return nsMap;
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public Repository getUnderlyingModelImplementation() {
        return this.getUnderlyingModelSetImplementation();
    }

    public Repository getUnderlyingModelSetImplementation() {
        return this.repository;
    }

    public boolean isOpen() {
        return this.connection != null;
    }

    public ClosableIterator<org.ontoware.rdf2go.model.Statement> iterator() {
        this.assertModel();
        try {
            RepositoryResult statements = this.connection.getStatements(null, null, null, true, new Resource[0]);
            return new StatementIterator((RepositoryResult<Statement>)statements);
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void open() {
        if (!this.isOpen()) {
            try {
                this.connection = this.repository.getConnection();
                this.connection.setAutoCommit(true);
            }
            catch (RepositoryException e) {
                throw new ModelRuntimeException((Throwable)e);
            }
        }
    }

    public ClosableIterable<org.ontoware.rdf2go.model.Statement> queryConstruct(String queryString, String queryLanguage) throws QueryLanguageNotSupportedException, ModelRuntimeException {
        this.assertModel();
        QueryLanguage language = ConversionUtil.toOpenRDFQueryLanguage(queryLanguage);
        try {
            GraphQuery query = this.connection.prepareGraphQuery(language, queryString);
            GraphQueryResult queryResult = query.evaluate();
            return new GraphIterable(queryResult, null);
        }
        catch (OpenRDFException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public QueryResultTable querySelect(String queryString, String queryLanguage) throws QueryLanguageNotSupportedException, ModelRuntimeException {
        this.assertModel();
        QueryLanguage language = ConversionUtil.toOpenRDFQueryLanguage(queryLanguage);
        return new RepositoryQueryResultTable(queryString, language, this.connection);
    }

    public void readFrom(InputStream in) throws IOException, ModelRuntimeException {
        this.readFrom(in, Syntax.RdfXml);
    }

    public void readFrom(InputStream in, Syntax syntax) throws IOException, ModelRuntimeException {
        this.assertModel();
        RDFFormat rdfformat = RDFFormat.forMIMEType((String)syntax.getMimeType());
        if (rdfformat == null) {
            throw new ModelRuntimeException("unknown Syntax: " + syntax.toString());
        }
        try {
            this.connection.add(in, "", rdfformat, new Resource[0]);
        }
        catch (OpenRDFException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void readFrom(InputStream in, Syntax syntax, String baseURI) throws IOException, ModelRuntimeException {
        this.assertModel();
        RDFFormat rdfformat = RDFFormat.forMIMEType((String)syntax.getMimeType());
        if (rdfformat == null) {
            throw new ModelRuntimeException("unknown Syntax: " + syntax.toString());
        }
        try {
            this.connection.add(in, baseURI, rdfformat, new Resource[0]);
        }
        catch (OpenRDFException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void readFrom(Reader reader) throws IOException, ModelRuntimeException {
        this.readFrom(reader, Syntax.RdfXml);
    }

    public void readFrom(Reader reader, Syntax syntax) throws IOException, ModelRuntimeException {
        this.assertModel();
        RDFFormat format = RDFFormat.forMIMEType((String)syntax.getMimeType());
        if (format == null) {
            throw new ModelRuntimeException("unknown RDF syntax: " + syntax.toString());
        }
        try {
            this.connection.add(reader, "", format, new Resource[0]);
        }
        catch (OpenRDFException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void readFrom(Reader reader, Syntax syntax, String baseURI) throws IOException, ModelRuntimeException {
        this.assertModel();
        RDFFormat format = RDFFormat.forMIMEType((String)syntax.getMimeType());
        if (format == null) {
            throw new ModelRuntimeException("unknown RDF syntax: " + syntax.toString());
        }
        try {
            this.connection.add(reader, baseURI, format, new Resource[0]);
        }
        catch (OpenRDFException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void removeAll() throws ModelRuntimeException {
        this.assertModel();
        try {
            this.connection.clear(new Resource[0]);
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Iterator<? extends org.ontoware.rdf2go.model.Statement> iterator) throws ModelRuntimeException {
        if (this.isLocked()) {
            throw new ModelRuntimeException("Model is locked, cannot perform an update.");
        }
        this.assertModel();
        try {
            boolean autocommitBefore = this.connection.isAutoCommit();
            this.connection.setAutoCommit(false);
            try {
                try {
                    while (iterator.hasNext()) {
                        org.ontoware.rdf2go.model.Statement s = iterator.next();
                        org.openrdf.model.URI context = ConversionUtil.toOpenRDF(s.getContext(), this.valueFactory);
                        Statement sd = ConversionUtil.toOpenRDF(s, this.valueFactory);
                        this.connection.remove(sd, new Resource[]{context});
                    }
                    this.connection.commit();
                }
                catch (RepositoryException x) {
                    this.connection.rollback();
                }
            }
            finally {
                this.connection.setAutoCommit(autocommitBefore);
            }
        }
        catch (RepositoryException x) {
            throw new ModelRuntimeException((Throwable)x);
        }
    }

    public boolean removeModel(URI contextURI) {
        this.assertModel();
        org.openrdf.model.URI context = ConversionUtil.toOpenRDF(contextURI, this.valueFactory);
        try {
            this.connection.clear(new Resource[]{context});
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        return true;
    }

    public void removeNamespace(String prefix) {
        this.assertModel();
        try {
            this.connection.removeNamespace(prefix);
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void removeStatement(org.ontoware.rdf2go.model.Statement statement) throws ModelRuntimeException {
        this.assertModel();
        try {
            Statement s = ConversionUtil.toOpenRDF(statement, this.valueFactory);
            this.connection.remove(s, new Resource[]{s.getContext()});
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void removeStatements(QuadPattern pattern) throws ModelRuntimeException {
        this.removeStatements(pattern.getContext(), pattern.getSubject(), pattern.getPredicate(), pattern.getObject());
    }

    public void removeStatements(UriOrVariable context, ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) throws ModelRuntimeException {
        this.assertModel();
        try {
            Resource s = (Resource)ConversionUtil.toOpenRDF(subject, this.valueFactory);
            org.openrdf.model.URI p = (org.openrdf.model.URI)ConversionUtil.toOpenRDF(predicate, this.valueFactory);
            Value o = ConversionUtil.toOpenRDF(object, this.valueFactory);
            Resource c = (Resource)ConversionUtil.toOpenRDF(context, this.valueFactory);
            if (c != null) {
                this.connection.remove(s, p, o, new Resource[]{c});
            } else {
                this.connection.remove(s, p, o, new Resource[0]);
            }
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void setAutocommit(boolean autocommit) {
        try {
            this.connection.setAutoCommit(autocommit);
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void setNamespace(String prefix, String namespaceURI) throws IllegalArgumentException {
        this.assertModel();
        try {
            this.connection.setNamespace(prefix, namespaceURI);
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void setUnderlyingModelSetImplementation(Repository repository) {
        boolean open = this.isOpen();
        if (open) {
            this.close();
        }
        this.init(repository);
        if (open) {
            this.open();
        }
    }

    public long size() throws ModelRuntimeException {
        this.assertModel();
        try {
            return this.connection.size(new Resource[0]);
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public boolean sparqlAsk(String queryString) throws ModelRuntimeException {
        this.assertModel();
        try {
            BooleanQuery booleanQuery = this.connection.prepareBooleanQuery(QueryLanguage.SPARQL, queryString);
            boolean result = booleanQuery.evaluate();
            return result;
        }
        catch (OpenRDFException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public ClosableIterable<org.ontoware.rdf2go.model.Statement> sparqlConstruct(String queryString) throws ModelRuntimeException {
        this.assertModel();
        try {
            GraphQuery query = this.connection.prepareGraphQuery(QueryLanguage.SPARQL, queryString);
            GraphQueryResult graphQueryResult = query.evaluate();
            return new StatementIterable((CloseableIteration<? extends Statement, ? extends OpenRDFException>)graphQueryResult, null);
        }
        catch (OpenRDFException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public ClosableIterable<org.ontoware.rdf2go.model.Statement> sparqlDescribe(String queryString) throws ModelRuntimeException {
        this.assertModel();
        try {
            GraphQuery query = this.connection.prepareGraphQuery(QueryLanguage.SPARQL, queryString);
            GraphQueryResult graphQueryResult = query.evaluate();
            return new StatementIterable((CloseableIteration<? extends Statement, ? extends OpenRDFException>)graphQueryResult, null);
        }
        catch (OpenRDFException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public QueryResultTable sparqlSelect(String queryString) throws ModelRuntimeException {
        return new RepositoryQueryResultTable(queryString, this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(DiffReader diff) throws ModelRuntimeException {
        if (this.isLocked()) {
            throw new ModelRuntimeException("ModelSet is locked, cannot perform an update.");
        }
        this.assertModel();
        try {
            boolean autocommitBefore = this.connection.isAutoCommit();
            this.connection.setAutoCommit(false);
            try {
                try {
                    Statement s;
                    Iterator it = diff.getRemoved().iterator();
                    while (it.hasNext()) {
                        s = ConversionUtil.toOpenRDF((org.ontoware.rdf2go.model.Statement)it.next(), this.valueFactory);
                        this.connection.remove(s, new Resource[]{s.getContext()});
                    }
                    it = diff.getAdded().iterator();
                    while (it.hasNext()) {
                        s = ConversionUtil.toOpenRDF((org.ontoware.rdf2go.model.Statement)it.next(), this.valueFactory);
                        this.connection.add(s, new Resource[]{s.getContext()});
                    }
                    this.connection.commit();
                }
                catch (RepositoryException x) {
                    this.connection.rollback();
                }
            }
            finally {
                this.connection.setAutoCommit(autocommitBefore);
            }
        }
        catch (RepositoryException x) {
            throw new ModelRuntimeException((Throwable)x);
        }
    }

    public void writeTo(OutputStream out) throws IOException, ModelRuntimeException {
        this.writeTo(out, Syntax.Trix);
    }

    public void writeTo(OutputStream out, Syntax syntax) throws IOException, ModelRuntimeException {
        RDFWriter rdfWriter = Rio.createWriter((RDFFormat)RepositoryModel.getRDFFormat(syntax), (OutputStream)out);
        this.writeTo(rdfWriter);
    }

    public void writeTo(Writer writer) throws IOException, ModelRuntimeException {
        this.writeTo(writer, Syntax.Trix);
    }

    public void writeTo(Writer writer, Syntax syntax) throws IOException, ModelRuntimeException {
        RDFWriter rdfWriter = Rio.createWriter((RDFFormat)RepositoryModel.getRDFFormat(syntax), (Writer)writer);
        this.writeTo(rdfWriter);
    }

    protected void assertModel() {
        if (this.repository == null) {
            throw new ModelRuntimeException("Repository is null");
        }
        if (this.connection == null) {
            throw new ModelRuntimeException("Connection is null");
        }
    }

    private void init(Repository repository) {
        this.repository = repository;
        this.valueFactory = repository.getValueFactory();
    }

    private void writeTo(RDFWriter writer) throws ModelRuntimeException {
        this.assertModel();
        try {
            this.connection.export((RDFHandler)writer, new Resource[0]);
        }
        catch (OpenRDFException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StatementIterator
    implements ClosableIterator<org.ontoware.rdf2go.model.Statement> {
        private RepositoryResult<Statement> result;

        public StatementIterator(RepositoryResult<Statement> result) {
            this.result = result;
        }

        public void close() {
            try {
                this.result.close();
            }
            catch (RepositoryException e) {
                throw new ModelRuntimeException((Throwable)e);
            }
        }

        public boolean hasNext() {
            try {
                return this.result.hasNext();
            }
            catch (RepositoryException e) {
                throw new ModelRuntimeException((Throwable)e);
            }
        }

        public org.ontoware.rdf2go.model.Statement next() {
            try {
                Statement statement = (Statement)this.result.next();
                return new StatementWrapper(null, statement);
            }
            catch (RepositoryException e) {
                throw new ModelRuntimeException((Throwable)e);
            }
        }

        public void remove() {
            try {
                this.result.remove();
            }
            catch (RepositoryException e) {
                throw new ModelRuntimeException((Throwable)e);
            }
        }
    }

    private class OpenRDFQuadPattern
    implements QuadPattern {
        private UriOrVariable context;
        private NodeOrVariable object;
        private UriOrVariable predicate;
        private ResourceOrVariable subject;

        public OpenRDFQuadPattern(UriOrVariable context, ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) {
            this.checkNonNull((NodeOrVariable)context);
            this.checkNonNull((NodeOrVariable)subject);
            this.checkNonNull((NodeOrVariable)predicate);
            this.checkNonNull(object);
            this.context = context;
            this.subject = subject;
            this.predicate = predicate;
            this.object = object;
        }

        public UriOrVariable getContext() {
            return this.context;
        }

        public NodeOrVariable getObject() {
            return this.object;
        }

        public UriOrVariable getPredicate() {
            return this.predicate;
        }

        public ResourceOrVariable getSubject() {
            return this.subject;
        }

        public boolean matches(org.ontoware.rdf2go.model.Statement statement) {
            return this.matches((Node)statement.getContext(), (NodeOrVariable)this.context) && this.matches((Node)statement.getSubject(), (NodeOrVariable)this.subject) && this.matches((Node)statement.getPredicate(), (NodeOrVariable)this.predicate) && this.matches(statement.getObject(), this.object);
        }

        private void checkNonNull(NodeOrVariable value) {
            if (value == null) {
                throw new NullPointerException();
            }
        }

        private boolean matches(Node node, NodeOrVariable variable) {
            return variable.equals(Variable.ANY) || variable.equals(node);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelIterator
    implements ClosableIterator<Model> {
        private ClosableIterator<URI> contextIterator;
        private URI lastURI;

        public ModelIterator(ClosableIterator<URI> contextIterator) {
            this.contextIterator = contextIterator;
        }

        public void close() {
            this.contextIterator.close();
        }

        public boolean hasNext() {
            return this.contextIterator.hasNext();
        }

        public Model next() {
            RepositoryModel model = null;
            URI uri = (URI)this.contextIterator.next();
            model = new RepositoryModel(uri, RepositoryModelSet.this.repository);
            model.open();
            this.lastURI = uri;
            return model;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this.lastURI == null) {
                throw new IllegalStateException();
            }
            RepositoryModel tmpModel = null;
            try {
                tmpModel = new RepositoryModel(this.lastURI, RepositoryModelSet.this.repository);
                tmpModel.removeAll();
            }
            finally {
                if (tmpModel != null) {
                    tmpModel.close();
                }
                this.lastURI = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextIterator
    implements ClosableIterator<URI> {
        private RepositoryResult<Resource> idIterator;

        public ContextIterator(RepositoryResult<Resource> idIterator) {
            this.idIterator = idIterator;
        }

        public void close() {
            try {
                this.idIterator.close();
            }
            catch (RepositoryException e) {
                throw new ModelRuntimeException((Throwable)e);
            }
        }

        public boolean hasNext() {
            try {
                return this.idIterator.hasNext();
            }
            catch (RepositoryException e) {
                throw new ModelRuntimeException((Throwable)e);
            }
        }

        public URI next() {
            try {
                return (URI)ConversionUtil.toRdf2go((Value)this.idIterator.next());
            }
            catch (RepositoryException e) {
                throw new ModelRuntimeException((Throwable)e);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

