/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rdf2go;

import java.util.Properties;
import org.ontoware.rdf2go.Reasoning;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.impl.AbstractModelFactory;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.ModelSet;
import org.ontoware.rdf2go.model.node.URI;
import org.openrdf.rdf2go.RepositoryModel;
import org.openrdf.rdf2go.RepositoryModelSet;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.Sail;
import org.openrdf.sail.inferencer.fc.ForwardChainingRDFSInferencer;
import org.openrdf.sail.memory.MemoryStore;

public class RepositoryModelFactory
extends AbstractModelFactory {
    public Model createModel(Properties properties) throws ModelRuntimeException {
        return new RepositoryModel(this.createRepository(properties));
    }

    public Model createModel(URI contextURI) throws ModelRuntimeException {
        return new RepositoryModel(contextURI, this.createRepository(null));
    }

    public ModelSet createModelSet(Properties properties) throws ModelRuntimeException {
        return new RepositoryModelSet(this.createRepository(properties));
    }

    private Repository createRepository(Properties properties) throws ModelRuntimeException {
        String reasoningProperty = properties == null ? null : properties.getProperty("Reasoning");
        boolean reasoning = Reasoning.rdfs.toString().equalsIgnoreCase(reasoningProperty);
        MemoryStore sail = new MemoryStore();
        if (reasoning) {
            sail = new ForwardChainingRDFSInferencer((Sail)sail);
        }
        SailRepository repository = new SailRepository((Sail)sail);
        try {
            repository.initialize();
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        return repository;
    }
}

