/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rdf2go;

import org.ontoware.rdf2go.exception.QueryLanguageNotSupportedException;
import org.ontoware.rdf2go.model.node.BlankNode;
import org.ontoware.rdf2go.model.node.DatatypeLiteral;
import org.ontoware.rdf2go.model.node.LanguageTagLiteral;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.PlainLiteral;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.model.node.impl.AbstractBlankNodeImpl;
import org.ontoware.rdf2go.model.node.impl.DatatypeLiteralImpl;
import org.ontoware.rdf2go.model.node.impl.LanguageTagLiteralImpl;
import org.ontoware.rdf2go.model.node.impl.PlainLiteralImpl;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.query.QueryLanguage;
import org.openrdf.rdf2go.OpenrdfBlankNode;

public class ConversionUtil {
    public static Value toOpenRDF(Object object, ValueFactory factory) {
        if (object == null) {
            return null;
        }
        if (object instanceof URI) {
            return ConversionUtil.toOpenRDF((URI)object, factory);
        }
        if (object instanceof String) {
            return ConversionUtil.toOpenRDF((String)object, factory);
        }
        if (object instanceof PlainLiteral) {
            return ConversionUtil.toOpenRDF((PlainLiteral)object, factory);
        }
        if (object instanceof LanguageTagLiteral) {
            return ConversionUtil.toOpenRDF((LanguageTagLiteral)object, factory);
        }
        if (object instanceof DatatypeLiteral) {
            return ConversionUtil.toOpenRDF((DatatypeLiteral)object, factory);
        }
        if (object instanceof BlankNode) {
            return ConversionUtil.toOpenRDF((BlankNode)object, factory);
        }
        if (object instanceof Variable) {
            return ConversionUtil.toOpenRDF((Variable)object, factory);
        }
        throw new IllegalArgumentException("Unexpected object type: " + object.getClass().getName());
    }

    public static org.openrdf.model.URI toOpenRDF(URI uri, ValueFactory factory) {
        return uri == null ? null : factory.createURI(uri.toString());
    }

    public static Literal toOpenRDF(String string, ValueFactory factory) {
        return string == null ? null : factory.createLiteral(string);
    }

    public static Literal toOpenRDF(PlainLiteral literal, ValueFactory factory) {
        return literal == null ? null : factory.createLiteral(literal.getValue());
    }

    public static Literal toOpenRDF(LanguageTagLiteral literal, ValueFactory factory) {
        return literal == null ? null : factory.createLiteral(literal.getValue(), literal.getLanguageTag());
    }

    public static Literal toOpenRDF(DatatypeLiteral literal, ValueFactory factory) {
        return literal == null ? null : factory.createLiteral(literal.getValue(), ConversionUtil.toOpenRDF(literal.getDatatype(), factory));
    }

    public static BNode toOpenRDF(BlankNode node, ValueFactory factory) {
        Object result = null;
        if (node != null) {
            Object underlyingBlankNode = ((AbstractBlankNodeImpl)node).getUnderlyingBlankNode();
            result = underlyingBlankNode instanceof BNode ? (BNode)underlyingBlankNode : new BNodeImpl(String.valueOf(underlyingBlankNode));
        }
        return result;
    }

    public static Value toOpenRDF(Variable variable, ValueFactory factory) {
        return null;
    }

    public static Statement toOpenRDF(org.ontoware.rdf2go.model.Statement statement, ValueFactory factory) {
        Resource subject = (Resource)ConversionUtil.toOpenRDF(statement.getSubject(), factory);
        org.openrdf.model.URI predicate = ConversionUtil.toOpenRDF(statement.getPredicate(), factory);
        Value object = ConversionUtil.toOpenRDF(statement.getObject(), factory);
        org.openrdf.model.URI context = ConversionUtil.toOpenRDF(statement.getContext(), factory);
        return factory.createStatement(subject, predicate, object, (Resource)context);
    }

    public static QueryLanguage toOpenRDFQueryLanguage(String queryLanguage) {
        if ((queryLanguage = queryLanguage.toLowerCase()).equals("sparql")) {
            return QueryLanguage.SPARQL;
        }
        if (queryLanguage.equals("serql")) {
            return QueryLanguage.SERQL;
        }
        if (queryLanguage.equals("serqo")) {
            return QueryLanguage.SERQO;
        }
        throw new QueryLanguageNotSupportedException("Query language '" + queryLanguage + "' not supported. Valid values are \"sparql\", \"serql\" and \"serqo\".");
    }

    public static Node toRdf2go(Value value) {
        if (value == null) {
            return null;
        }
        if (value instanceof org.openrdf.model.URI) {
            return ConversionUtil.toRdf2go((org.openrdf.model.URI)value);
        }
        if (value instanceof Literal) {
            return ConversionUtil.toRdf2go((Literal)value);
        }
        if (value instanceof BNode) {
            return ConversionUtil.toRdf2go((BNode)value);
        }
        throw new IllegalArgumentException("Unexpected Value type: " + value.getClass().getName());
    }

    public static URI toRdf2go(org.openrdf.model.URI uri) {
        return uri == null ? null : new URIImpl(uri.toString(), false);
    }

    public static org.ontoware.rdf2go.model.node.Literal toRdf2go(Literal literal) {
        if (literal == null) {
            return null;
        }
        String label = literal.getLabel();
        String language = literal.getLanguage();
        org.openrdf.model.URI dataType = literal.getDatatype();
        if (language != null) {
            return new LanguageTagLiteralImpl(label, language);
        }
        if (dataType != null) {
            return new DatatypeLiteralImpl(label, (URI)new URIImpl(dataType.toString(), false));
        }
        return new PlainLiteralImpl(label);
    }

    public static BlankNode toRdf2go(BNode node) {
        return node == null ? null : new OpenrdfBlankNode(node);
    }
}

