/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf;

import org.semarglproject.rdf.NTriplesSerializer;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.sink.CharSink;
import org.semarglproject.sink.QuadSink;

public class NQuadsSerializer
extends NTriplesSerializer
implements QuadSink {
    private NQuadsSerializer(CharSink sink) {
        super(sink);
    }

    public static QuadSink connect(CharSink sink) {
        return new NQuadsSerializer(sink);
    }

    public void addNonLiteral(String subj, String pred, String obj, String graph) {
        try {
            this.startTriple(subj, pred);
            this.serializeBnodeOrUri(obj);
            if (graph != null) {
                this.serializeBnodeOrUri(graph);
            }
            ((CharSink)this.sink).process(".\n");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void addPlainLiteral(String subj, String pred, String content, String lang, String graph) {
        try {
            this.startTriple(subj, pred);
            this.addContent(content);
            if (lang != null) {
                ((CharSink)this.sink).process('@').process(lang);
            }
            ((CharSink)this.sink).process(' ');
            if (graph != null) {
                this.serializeBnodeOrUri(graph);
            }
            ((CharSink)this.sink).process(".\n");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void addTypedLiteral(String subj, String pred, String content, String type, String graph) {
        try {
            this.startTriple(subj, pred);
            this.addContent(content);
            ((CharSink)this.sink).process("^^");
            this.serializeUri(type);
            if (graph != null) {
                this.serializeBnodeOrUri(graph);
            }
            ((CharSink)this.sink).process(".\n");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }
}

