/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.decorators;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.support.decorators.Decorated;
import org.openqa.selenium.support.decorators.DefaultDecorated;
import org.openqa.selenium.virtualauthenticator.VirtualAuthenticator;

@Beta
public class WebDriverDecorator {
    private Decorated<WebDriver> decorated;

    public final WebDriver decorate(WebDriver original) {
        Require.nonNull((String)"WebDriver", (Object)original);
        this.decorated = this.createDecorated(original);
        return this.createProxy(this.decorated, WebDriver.class);
    }

    public Decorated<WebDriver> getDecoratedDriver() {
        return this.decorated;
    }

    public Decorated<WebDriver> createDecorated(WebDriver driver) {
        return new DefaultDecorated<WebDriver>(driver, this);
    }

    public Decorated<WebElement> createDecorated(WebElement original) {
        return new DefaultDecorated<WebElement>(original, this);
    }

    public Decorated<WebDriver.TargetLocator> createDecorated(WebDriver.TargetLocator original) {
        return new DefaultDecorated<WebDriver.TargetLocator>(original, this);
    }

    public Decorated<WebDriver.Navigation> createDecorated(WebDriver.Navigation original) {
        return new DefaultDecorated<WebDriver.Navigation>(original, this);
    }

    public Decorated<WebDriver.Options> createDecorated(WebDriver.Options original) {
        return new DefaultDecorated<WebDriver.Options>(original, this);
    }

    public Decorated<WebDriver.Timeouts> createDecorated(WebDriver.Timeouts original) {
        return new DefaultDecorated<WebDriver.Timeouts>(original, this);
    }

    public Decorated<WebDriver.Window> createDecorated(WebDriver.Window original) {
        return new DefaultDecorated<WebDriver.Window>(original, this);
    }

    public Decorated<Alert> createDecorated(Alert original) {
        return new DefaultDecorated<Alert>(original, this);
    }

    public Decorated<VirtualAuthenticator> createDecorated(VirtualAuthenticator original) {
        return new DefaultDecorated<VirtualAuthenticator>(original, this);
    }

    public void beforeCall(Decorated<?> target, Method method, Object[] args) {
    }

    public Object call(Decorated<?> target, Method method, Object[] args) throws Throwable {
        return this.decorateResult(method.invoke(target.getOriginal(), args));
    }

    public void afterCall(Decorated<?> target, Method method, Object[] args, Object res) {
    }

    public Object onError(Decorated<?> target, Method method, Object[] args, InvocationTargetException e) throws Throwable {
        throw e.getTargetException();
    }

    private Object decorateResult(Object toDecorate) {
        if (toDecorate instanceof WebDriver) {
            return this.createProxy(this.getDecoratedDriver(), WebDriver.class);
        }
        if (toDecorate instanceof WebElement) {
            return this.createProxy(this.createDecorated((WebElement)toDecorate), WebElement.class);
        }
        if (toDecorate instanceof Alert) {
            return this.createProxy(this.createDecorated((Alert)toDecorate), Alert.class);
        }
        if (toDecorate instanceof VirtualAuthenticator) {
            return this.createProxy(this.createDecorated((VirtualAuthenticator)toDecorate), VirtualAuthenticator.class);
        }
        if (toDecorate instanceof WebDriver.Navigation) {
            return this.createProxy(this.createDecorated((WebDriver.Navigation)toDecorate), WebDriver.Navigation.class);
        }
        if (toDecorate instanceof WebDriver.Options) {
            return this.createProxy(this.createDecorated((WebDriver.Options)toDecorate), WebDriver.Options.class);
        }
        if (toDecorate instanceof WebDriver.TargetLocator) {
            return this.createProxy(this.createDecorated((WebDriver.TargetLocator)toDecorate), WebDriver.TargetLocator.class);
        }
        if (toDecorate instanceof WebDriver.Timeouts) {
            return this.createProxy(this.createDecorated((WebDriver.Timeouts)toDecorate), WebDriver.Timeouts.class);
        }
        if (toDecorate instanceof WebDriver.Window) {
            return this.createProxy(this.createDecorated((WebDriver.Window)toDecorate), WebDriver.Window.class);
        }
        if (toDecorate instanceof List) {
            return ((List)toDecorate).stream().map(this::decorateResult).collect(Collectors.toList());
        }
        return toDecorate;
    }

    protected final <Z> Z createProxy(Decorated<Z> decorated, Class<Z> clazz) {
        Set<Class<?>> decoratedInterfaces = WebDriverDecorator.extractInterfaces(decorated);
        Set<Class<?>> originalInterfaces = WebDriverDecorator.extractInterfaces(decorated.getOriginal());
        Map<Class<?>, InvocationHandler> derivedInterfaces = this.deriveAdditionalInterfaces(decorated.getOriginal());
        InvocationHandler handler = (proxy, method, args) -> {
            try {
                if (method.getDeclaringClass().equals(Object.class) || decoratedInterfaces.contains(method.getDeclaringClass())) {
                    return method.invoke((Object)decorated, args);
                }
                if (originalInterfaces.contains(method.getDeclaringClass())) {
                    decorated.beforeCall(method, args);
                    Object result = decorated.call(method, args);
                    decorated.afterCall(method, result, args);
                    return result;
                }
                if (derivedInterfaces.containsKey(method.getDeclaringClass())) {
                    return ((InvocationHandler)derivedInterfaces.get(method.getDeclaringClass())).invoke(proxy, method, args);
                }
                return method.invoke(decorated.getOriginal(), args);
            }
            catch (InvocationTargetException e) {
                return decorated.onError(method, e, args);
            }
        };
        HashSet allInterfaces = new HashSet();
        allInterfaces.addAll(decoratedInterfaces);
        allInterfaces.addAll(originalInterfaces);
        allInterfaces.addAll(derivedInterfaces.keySet());
        Type[] allInterfacesArray = allInterfaces.toArray(new Class[0]);
        Class<Z> proxy2 = new ByteBuddy().subclass(Object.class).implement(allInterfacesArray).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)handler)).make().load(clazz.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded().asSubclass(clazz);
        try {
            return proxy2.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Unable to create new proxy", e);
        }
    }

    static Set<Class<?>> extractInterfaces(Object object) {
        return WebDriverDecorator.extractInterfaces(object.getClass());
    }

    private static Set<Class<?>> extractInterfaces(Class<?> clazz) {
        HashSet allInterfaces = new HashSet();
        WebDriverDecorator.extractInterfaces(allInterfaces, clazz);
        return allInterfaces;
    }

    private static void extractInterfaces(Set<Class<?>> collector, Class<?> clazz) {
        Class<?>[] classes;
        if (clazz == null || Object.class.equals(clazz)) {
            return;
        }
        for (Class<?> interfaceClass : classes = clazz.getInterfaces()) {
            collector.add(interfaceClass);
            for (Class<?> superInterface : interfaceClass.getInterfaces()) {
                collector.add(superInterface);
                WebDriverDecorator.extractInterfaces(collector, superInterface);
            }
        }
        WebDriverDecorator.extractInterfaces(collector, clazz.getSuperclass());
    }

    private Map<Class<?>, InvocationHandler> deriveAdditionalInterfaces(Object object) {
        HashMap handlers = new HashMap();
        if (object instanceof WebDriver && !(object instanceof WrapsDriver)) {
            handlers.put(WrapsDriver.class, (proxy, method, args) -> {
                if ("getWrappedDriver".equals(method.getName())) {
                    return object;
                }
                throw new UnsupportedOperationException(method.getName());
            });
        }
        if (object instanceof WebElement && !(object instanceof WrapsElement)) {
            handlers.put(WrapsElement.class, (proxy, method, args) -> {
                if ("getWrappedElement".equals(method.getName())) {
                    return object;
                }
                throw new UnsupportedOperationException(method.getName());
            });
        }
        try {
            Method toJson = object.getClass().getDeclaredMethod("toJson", new Class[0]);
            toJson.setAccessible(true);
            handlers.put(JsonSerializer.class, (proxy, method, args) -> {
                if ("toJson".equals(method.getName())) {
                    return toJson.invoke(object, new Object[0]);
                }
                throw new UnsupportedOperationException(method.getName());
            });
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return handlers;
    }

    @FunctionalInterface
    protected static interface JsonSerializer {
        public Object toJson();
    }
}

