/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.support.Colors;

public class Color {
    private final int red;
    private final int green;
    private final int blue;
    private double alpha;
    private static final Converter[] CONVERTERS = new Converter[]{new RgbConverter(), new RgbPctConverter(), new RgbaConverter(), new RgbaPctConverter(), new HexConverter(), new Hex3Converter(), new HslConverter(), new HslaConverter(), new NamedColorConverter()};

    public static Color fromString(String value) {
        for (Converter converter : CONVERTERS) {
            Color color = converter.getColor(value);
            if (color == null) continue;
            return color;
        }
        throw new IllegalArgumentException(String.format("Did not know how to convert %s into color", value));
    }

    public Color(int red, int green, int blue, double alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public void setOpacity(double alpha) {
        this.alpha = alpha;
    }

    public String asRgb() {
        return String.format("rgb(%d, %d, %d)", this.red, this.green, this.blue);
    }

    public String asRgba() {
        String alphaString = this.alpha == 1.0 ? "1" : (this.alpha == 0.0 ? "0" : Double.toString(this.alpha));
        return String.format("rgba(%d, %d, %d, %s)", this.red, this.green, this.blue, alphaString);
    }

    public String asHex() {
        return String.format("#%02x%02x%02x", this.red, this.green, this.blue);
    }

    public java.awt.Color getColor() {
        return new java.awt.Color(this.red, this.green, this.blue, (int)(this.alpha * 255.0));
    }

    public String toString() {
        return "Color: " + this.asRgba();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Color)) {
            return false;
        }
        return this.asRgba().equals(((Color)other).asRgba());
    }

    public int hashCode() {
        int result = this.red;
        result = 31 * result + this.green;
        result = 31 * result + this.blue;
        long temp = this.alpha != 0.0 ? Double.doubleToLongBits(this.alpha) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    private static abstract class Converter {
        private Converter() {
        }

        public Color getColor(String value) {
            Matcher matcher = this.getPattern().matcher(value);
            if (matcher.find()) {
                double a = 1.0;
                if (matcher.groupCount() == 4) {
                    a = Double.parseDouble(matcher.group(4));
                }
                return this.createColor(matcher, a);
            }
            return null;
        }

        protected Color createColor(Matcher matcher, double a) {
            return new Color(this.fromMatchGroup(matcher, 1), this.fromMatchGroup(matcher, 2), this.fromMatchGroup(matcher, 3), a);
        }

        protected short fromMatchGroup(Matcher matcher, int index) {
            return Short.parseShort(matcher.group(index), 10);
        }

        protected abstract Pattern getPattern();
    }

    private static class RgbConverter
    extends Converter {
        private static final Pattern RGB_PATTERN = Pattern.compile("^\\s*rgb\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*\\)\\s*$");

        private RgbConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return RGB_PATTERN;
        }
    }

    private static class RgbPctConverter
    extends Converter {
        private static final Pattern RGBPCT_PATTERN = Pattern.compile("^\\s*rgb\\(\\s*(\\d{1,3}|\\d{1,2}\\.\\d+)%\\s*,\\s*(\\d{1,3}|\\d{1,2}\\.\\d+)%\\s*,\\s*(\\d{1,3}|\\d{1,2}\\.\\d+)%\\s*\\)\\s*$");

        private RgbPctConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return RGBPCT_PATTERN;
        }

        @Override
        protected short fromMatchGroup(Matcher matcher, int index) {
            double n = Double.parseDouble(matcher.group(index)) / 100.0 * 255.0;
            return (short)n;
        }
    }

    private static class RgbaConverter
    extends RgbConverter {
        private static final Pattern RGBA_PATTERN = Pattern.compile("^\\s*rgba\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(0|1|0\\.\\d+)\\s*\\)\\s*$");

        private RgbaConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return RGBA_PATTERN;
        }
    }

    private static class RgbaPctConverter
    extends RgbPctConverter {
        private static final Pattern RGBAPCT_PATTERN = Pattern.compile("^\\s*rgba\\(\\s*(\\d{1,3}|\\d{1,2}\\.\\d+)%\\s*,\\s*(\\d{1,3}|\\d{1,2}\\.\\d+)%\\s*,\\s*(\\d{1,3}|\\d{1,2}\\.\\d+)%\\s*,\\s*(0|1|0\\.\\d+)\\s*\\)\\s*$");

        private RgbaPctConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return RGBAPCT_PATTERN;
        }
    }

    private static class HexConverter
    extends Converter {
        private static final Pattern HEX_PATTERN = Pattern.compile("#(\\p{XDigit}{2})(\\p{XDigit}{2})(\\p{XDigit}{2})");

        private HexConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return HEX_PATTERN;
        }

        @Override
        protected short fromMatchGroup(Matcher matcher, int index) {
            return Short.parseShort(matcher.group(index), 16);
        }
    }

    private static class Hex3Converter
    extends Converter {
        private static final Pattern HEX3_PATTERN = Pattern.compile("#(\\p{XDigit}{1})(\\p{XDigit}{1})(\\p{XDigit}{1})");

        private Hex3Converter() {
        }

        @Override
        protected Pattern getPattern() {
            return HEX3_PATTERN;
        }

        @Override
        protected short fromMatchGroup(Matcher matcher, int index) {
            return Short.parseShort(matcher.group(index) + matcher.group(index), 16);
        }
    }

    private static class HslConverter
    extends Converter {
        private static final Pattern HSL_PATTERN = Pattern.compile("^\\s*hsl\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\%\\s*,\\s*(\\d{1,3})\\%\\s*\\)\\s*$");

        private HslConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return HSL_PATTERN;
        }

        @Override
        protected Color createColor(Matcher matcher, double a) {
            double b;
            double g;
            double r;
            double h = Double.parseDouble(matcher.group(1)) / 360.0;
            double s = Double.parseDouble(matcher.group(2)) / 100.0;
            double l = Double.parseDouble(matcher.group(3)) / 100.0;
            if (s == 0.0) {
                g = r = l;
                b = r;
            } else {
                double luminocity2 = l < 0.5 ? l * (1.0 + s) : l + s - l * s;
                double luminocity1 = 2.0 * l - luminocity2;
                r = this.hueToRgb(luminocity1, luminocity2, h + 0.3333333333333333);
                g = this.hueToRgb(luminocity1, luminocity2, h);
                b = this.hueToRgb(luminocity1, luminocity2, h - 0.3333333333333333);
            }
            return new Color((short)Math.round(r * 255.0), (short)Math.round(g * 255.0), (short)Math.round(b * 255.0), a);
        }

        private double hueToRgb(double luminocity1, double luminocity2, double hue) {
            if (hue < 0.0) {
                hue += 1.0;
            }
            if (hue > 1.0) {
                hue -= 1.0;
            }
            if (hue < 0.16666666666666666) {
                return luminocity1 + (luminocity2 - luminocity1) * 6.0 * hue;
            }
            if (hue < 0.5) {
                return luminocity2;
            }
            if (hue < 0.6666666666666666) {
                return luminocity1 + (luminocity2 - luminocity1) * (0.6666666666666666 - hue) * 6.0;
            }
            return luminocity1;
        }
    }

    private static class HslaConverter
    extends HslConverter {
        private static final Pattern HSLA_PATTERN = Pattern.compile("^\\s*hsla\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\%\\s*,\\s*(\\d{1,3})\\%\\s*,\\s*(0|1|0\\.\\d+)\\s*\\)\\s*$");

        private HslaConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return HSLA_PATTERN;
        }
    }

    private static class NamedColorConverter
    extends Converter {
        private NamedColorConverter() {
        }

        @Override
        public Color getColor(String value) {
            return Colors.valueOf(value.toUpperCase()).getColorValue();
        }

        @Override
        public Pattern getPattern() {
            throw new UnsupportedOperationException("getPattern is unsupported");
        }
    }
}

