/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.pagefactory;

import java.lang.reflect.Field;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.AbstractAnnotations;
import org.openqa.selenium.support.pagefactory.Annotations;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class DefaultElementLocator
implements ElementLocator {
    private final SearchContext searchContext;
    private final boolean shouldCache;
    private final By by;
    private WebElement cachedElement;
    private List<WebElement> cachedElementList;

    public DefaultElementLocator(SearchContext searchContext, Field field) {
        this(searchContext, new Annotations(field));
    }

    public DefaultElementLocator(SearchContext searchContext, AbstractAnnotations annotations) {
        this.searchContext = searchContext;
        this.shouldCache = annotations.isLookupCached();
        this.by = annotations.buildBy();
    }

    @Override
    public WebElement findElement() {
        if (this.cachedElement != null && this.shouldCache()) {
            return this.cachedElement;
        }
        WebElement element = this.searchContext.findElement(this.by);
        if (this.shouldCache()) {
            this.cachedElement = element;
        }
        return element;
    }

    @Override
    public List<WebElement> findElements() {
        if (this.cachedElementList != null && this.shouldCache()) {
            return this.cachedElementList;
        }
        List elements = this.searchContext.findElements(this.by);
        if (this.shouldCache()) {
            this.cachedElementList = elements;
        }
        return elements;
    }

    protected boolean shouldCache() {
        return this.shouldCache;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " '" + this.by + "'";
    }
}

