/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.ui;

import java.util.concurrent.TimeUnit;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;

public class WebDriverWait
extends FluentWait<WebDriver> {
    public static final long DEFAULT_SLEEP_TIMEOUT = 500L;
    private final WebDriver driver;

    public WebDriverWait(WebDriver driver, long timeOutInSeconds) {
        this(driver, new SystemClock(), Sleeper.SYSTEM_SLEEPER, timeOutInSeconds, 500L);
    }

    public WebDriverWait(WebDriver driver, long timeOutInSeconds, long sleepInMillis) {
        this(driver, new SystemClock(), Sleeper.SYSTEM_SLEEPER, timeOutInSeconds, sleepInMillis);
    }

    public WebDriverWait(WebDriver driver, Clock clock, Sleeper sleeper, long timeOutInSeconds, long sleepTimeOut) {
        super(driver, clock, sleeper);
        this.withTimeout(timeOutInSeconds, TimeUnit.SECONDS);
        this.pollingEvery(sleepTimeOut, TimeUnit.MILLISECONDS);
        this.ignoring(NotFoundException.class);
        this.driver = driver;
    }

    @Override
    protected RuntimeException timeoutException(String message, Throwable lastException) {
        TimeoutException ex = new TimeoutException(message, lastException);
        ex.addInfo("Driver info", this.driver.getClass().getName());
        if (this.driver instanceof RemoteWebDriver) {
            RemoteWebDriver remote = (RemoteWebDriver)this.driver;
            if (remote.getSessionId() != null) {
                ex.addInfo("Session ID", remote.getSessionId().toString());
            }
            if (remote.getCapabilities() != null) {
                ex.addInfo("Capabilities", remote.getCapabilities().toString());
            }
        }
        throw ex;
    }
}

