/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.pagefactory;

import java.lang.reflect.Field;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.DefaultElementLocator;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.SlowLoadableComponent;
import org.openqa.selenium.support.ui.SystemClock;

public class AjaxElementLocator
extends DefaultElementLocator {
    protected final int timeOutInSeconds;
    private final Clock clock;

    public AjaxElementLocator(WebDriver driver, Field field, int timeOutInSeconds) {
        this(new SystemClock(), driver, field, timeOutInSeconds);
    }

    public AjaxElementLocator(Clock clock, WebDriver driver, Field field, int timeOutInSeconds) {
        super((SearchContext)driver, field);
        this.timeOutInSeconds = timeOutInSeconds;
        this.clock = clock;
    }

    @Override
    public WebElement findElement() {
        SlowLoadingElement loadingElement = new SlowLoadingElement(this.clock, this.timeOutInSeconds);
        try {
            return ((SlowLoadingElement)loadingElement.get()).getElement();
        }
        catch (NoSuchElementError e) {
            throw new NoSuchElementException(String.format("Timed out after %d seconds. %s", this.timeOutInSeconds, e.getMessage()), e.getCause());
        }
    }

    protected long sleepFor() {
        return 250L;
    }

    protected boolean isElementUsable(WebElement element) {
        return true;
    }

    private static class NoSuchElementError
    extends Error {
        private NoSuchElementError(String message, Throwable throwable) {
            super(message, throwable);
        }
    }

    private class SlowLoadingElement
    extends SlowLoadableComponent<SlowLoadingElement> {
        private NoSuchElementException lastException;
        private WebElement element;

        public SlowLoadingElement(Clock clock, int timeOutInSeconds) {
            super(clock, timeOutInSeconds);
        }

        @Override
        protected void load() {
        }

        @Override
        protected long sleepFor() {
            return AjaxElementLocator.this.sleepFor();
        }

        @Override
        protected void isLoaded() throws Error {
            try {
                this.element = AjaxElementLocator.super.findElement();
                if (!AjaxElementLocator.this.isElementUsable(this.element)) {
                    throw new NoSuchElementException("Element is not usable");
                }
            }
            catch (NoSuchElementException e) {
                this.lastException = e;
                throw new NoSuchElementError("Unable to locate the element", e);
            }
        }

        public NoSuchElementException getLastException() {
            return this.lastException;
        }

        public WebElement getElement() {
            return this.element;
        }
    }
}

