/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.config.JsonConfig;
import org.openqa.selenium.grid.config.TomlConfig;
import org.openqa.selenium.internal.Require;

public class Configs {
    private Configs() {
    }

    public static Config from(Path path) {
        Require.nonNull((String)"Path to read from", (Object)path);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new ConfigException("Path to read from does not exist: " + path, new Object[0]);
        }
        String fileName = path.getFileName().toString();
        if (fileName.endsWith(".tml") || fileName.endsWith(".toml")) {
            return TomlConfig.from(path);
        }
        if (fileName.endsWith(".json")) {
            return JsonConfig.from(path);
        }
        throw new ConfigException("Unable to determine file type. The file extension must be one of '.toml' or '.json' " + path, new Object[0]);
    }
}

