/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi;

import com.google.auto.service.AutoService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.BiDiException;
import org.openqa.selenium.bidi.Connection;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;

@AutoService(value={AugmenterProvider.class})
public class BiDiProvider
implements AugmenterProvider<HasBiDi> {
    @Override
    public Predicate<Capabilities> isApplicable() {
        return caps -> this.getBiDiUrl((Capabilities)caps).isPresent();
    }

    @Override
    public Class<HasBiDi> getDescribedInterface() {
        return HasBiDi.class;
    }

    @Override
    public HasBiDi getImplementation(Capabilities caps, ExecuteMethod executeMethod) {
        URI wsUri = this.getBiDiUrl(caps).orElseThrow(() -> new BiDiException("BiDi not supported"));
        HttpClient.Factory clientFactory = HttpClient.Factory.createDefault();
        ClientConfig wsConfig = ClientConfig.defaultConfig().baseUri(wsUri);
        HttpClient wsClient = clientFactory.createClient(wsConfig);
        Connection connection = new Connection(wsClient, wsUri.toString());
        return () -> Optional.of(new BiDi(connection));
    }

    private Optional<URI> getBiDiUrl(Capabilities caps) {
        Object biDiCapability = caps.getCapability("webSocketUrl");
        Optional<String> webSocketUrl = Optional.ofNullable((String)biDiCapability);
        return webSocketUrl.map(uri -> {
            try {
                return new URI((String)uri);
            }
            catch (URISyntaxException e) {
                return null;
            }
        });
    }
}

