/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browsingcontext;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Locator {
    final Map<String, Object> map = new HashMap<String, Object>();

    private Locator(Type type, String value) {
        this.map.put("type", type.toString());
        this.map.put("value", value);
    }

    private Locator(Type type, String value, Optional<Boolean> ignoreCase, Optional<String> matchType, Optional<Long> maxDepth) {
        this.map.put("type", type.toString());
        this.map.put("value", value);
        ignoreCase.ifPresent(val -> this.map.put("ignoreCase", val));
        matchType.ifPresent(val -> this.map.put("matchType", val));
        maxDepth.ifPresent(val -> this.map.put("maxDepth", val));
    }

    public static Locator css(String value) {
        return new Locator(Type.CSS, value);
    }

    public static Locator innerText(String value, Optional<Boolean> ignoreCase, Optional<String> matchType, Optional<Long> maxDepth) {
        return new Locator(Type.INNER, value, ignoreCase, matchType, maxDepth);
    }

    public static Locator innerText(String value) {
        return new Locator(Type.INNER, value);
    }

    public static Locator xpath(String value) {
        return new Locator(Type.XPATH, value);
    }

    public Map<String, Object> toMap() {
        return this.map;
    }

    private static enum Type {
        CSS("css"),
        INNER("innerText"),
        XPATH("xpath");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

