/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.storage;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.bidi.network.Cookie;
import org.openqa.selenium.bidi.storage.PartitionKey;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class GetCookiesResult {
    private final List<Cookie> cookies;
    private final PartitionKey partitionKey;

    public GetCookiesResult(List<Cookie> cookies, PartitionKey partitionKey) {
        this.cookies = cookies;
        this.partitionKey = partitionKey;
    }

    public static GetCookiesResult fromJson(JsonInput input) {
        List<Cookie> cookies = new ArrayList<Cookie>();
        PartitionKey partitionKey = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "cookies": {
                    cookies = (List)input.read(new TypeToken<List<Cookie>>(){}.getType());
                    continue block8;
                }
                case "partitionKey": {
                    partitionKey = (PartitionKey)input.read(PartitionKey.class);
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new GetCookiesResult(cookies, partitionKey);
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public PartitionKey getPartitionKey() {
        return this.partitionKey;
    }
}

