/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing.opentelemetry;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import io.grpc.Context;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.context.Scope;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.StatusCanonicalCode;
import io.opentelemetry.trace.Tracer;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryContext;

class OpenTelemetrySpan
extends OpenTelemetryContext
implements AutoCloseable,
Span {
    private final io.opentelemetry.trace.Span span;
    private final Scope scope;
    private static final Map<Status.Kind, StatusCanonicalCode> statuses = new ImmutableMap.Builder().put((Object)Status.Kind.ABORTED, (Object)StatusCanonicalCode.ERROR).put((Object)Status.Kind.CANCELLED, (Object)StatusCanonicalCode.ERROR).put((Object)Status.Kind.NOT_FOUND, (Object)StatusCanonicalCode.ERROR).put((Object)Status.Kind.OK, (Object)StatusCanonicalCode.OK).put((Object)Status.Kind.RESOURCE_EXHAUSTED, (Object)StatusCanonicalCode.ERROR).put((Object)Status.Kind.UNKNOWN, (Object)StatusCanonicalCode.ERROR).put((Object)Status.Kind.INVALID_ARGUMENT, (Object)StatusCanonicalCode.ERROR).put((Object)Status.Kind.DEADLINE_EXCEEDED, (Object)StatusCanonicalCode.ERROR).put((Object)Status.Kind.ALREADY_EXISTS, (Object)StatusCanonicalCode.ERROR).put((Object)Status.Kind.PERMISSION_DENIED, (Object)StatusCanonicalCode.ERROR).put((Object)Status.Kind.OUT_OF_RANGE, (Object)StatusCanonicalCode.ERROR).put((Object)Status.Kind.UNIMPLEMENTED, (Object)StatusCanonicalCode.ERROR).put((Object)Status.Kind.INTERNAL, (Object)StatusCanonicalCode.ERROR).put((Object)Status.Kind.UNAVAILABLE, (Object)StatusCanonicalCode.ERROR).put((Object)Status.Kind.UNAUTHENTICATED, (Object)StatusCanonicalCode.ERROR).build();

    public OpenTelemetrySpan(Tracer tracer, Context context, io.opentelemetry.trace.Span span, Scope scope) {
        super(tracer, context);
        this.span = (io.opentelemetry.trace.Span)Require.nonNull((String)"Span", (Object)span);
        this.scope = (Scope)Require.nonNull((String)"Scope", (Object)scope);
    }

    @Override
    public Span setName(String name) {
        this.span.updateName((String)Require.nonNull((String)"Name to update to", (Object)name));
        return this;
    }

    @Override
    public Span setAttribute(String key, boolean value) {
        this.span.setAttribute((String)Require.nonNull((String)"Key", (Object)key), value);
        return this;
    }

    @Override
    public Span setAttribute(String key, Number value) {
        Require.nonNull((String)"Key", (Object)key);
        Require.nonNull((String)"Value", (Object)value);
        Class unwrapped = Primitives.unwrap(value.getClass());
        if (Double.TYPE.equals(unwrapped) || Float.TYPE.equals(unwrapped)) {
            this.span.setAttribute(key, value.doubleValue());
        } else {
            this.span.setAttribute(key, value.longValue());
        }
        return this;
    }

    @Override
    public Span setAttribute(String key, String value) {
        Require.nonNull((String)"Key", (Object)key);
        Require.nonNull((String)"Value", (Object)value);
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public Span addEvent(String name) {
        Require.nonNull((String)"Name", (Object)name);
        this.span.addEvent(name);
        return this;
    }

    @Override
    public Span addEvent(String name, Map<String, EventAttributeValue> attributeMap) {
        Require.nonNull((String)"Name", (Object)name);
        Require.nonNull((String)"Event Attribute Map", attributeMap);
        Attributes.Builder otAttributes = Attributes.newBuilder();
        attributeMap.forEach((key, value) -> {
            Require.nonNull((String)"Event Attribute Value", (Object)value);
            switch (value.getAttributeType()) {
                case BOOLEAN: {
                    otAttributes.setAttribute(key, value.getBooleanValue().booleanValue());
                    break;
                }
                case BOOLEAN_ARRAY: {
                    otAttributes.setAttribute(key, value.getBooleanArrayValue());
                    break;
                }
                case DOUBLE: {
                    otAttributes.setAttribute(key, value.getNumberValue().doubleValue());
                    break;
                }
                case DOUBLE_ARRAY: {
                    otAttributes.setAttribute(key, value.getDoubleArrayValue());
                    break;
                }
                case LONG: {
                    otAttributes.setAttribute(key, value.getNumberValue().longValue());
                    break;
                }
                case LONG_ARRAY: {
                    otAttributes.setAttribute(key, value.getLongArrayValue());
                    break;
                }
                case STRING: {
                    otAttributes.setAttribute(key, value.getStringValue());
                    break;
                }
                case STRING_ARRAY: {
                    otAttributes.setAttribute(key, value.getStringArrayValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized event attribute value type: " + (Object)((Object)value.getAttributeType()));
                }
            }
        });
        this.span.addEvent(name, otAttributes.build());
        return this;
    }

    @Override
    public Span setStatus(Status status) {
        Require.nonNull((String)"Status", (Object)status);
        StatusCanonicalCode statusCanonicalCode = statuses.get((Object)status.getKind());
        if (statusCanonicalCode == null) {
            throw new IllegalArgumentException("Unrecognized status kind: " + (Object)((Object)status.getKind()));
        }
        this.span.setStatus(statusCanonicalCode, "Kind: " + status.getKind().toString() + " Description:" + status.getDescription());
        return this;
    }

    @Override
    public void close() {
        this.scope.close();
        this.span.end();
    }

    @Override
    public String toString() {
        SpanContext context = this.span.getContext();
        return "OpenTelemetrySpan{traceId=" + context.getTraceIdAsHexString() + ",spanId=" + context.getSpanIdAsHexString() + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof OpenTelemetryContext && !(o instanceof OpenTelemetrySpan)) {
            return false;
        }
        if (!(o instanceof OpenTelemetrySpan)) {
            return false;
        }
        OpenTelemetrySpan that = (OpenTelemetrySpan)o;
        SpanContext thisContext = this.span.getContext();
        SpanContext thatContext = that.span.getContext();
        return Objects.equals(thisContext.getSpanIdAsHexString(), thatContext.getSpanIdAsHexString()) && Objects.equals(thisContext.getTraceIdAsHexString(), thatContext.getTraceIdAsHexString());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.span);
    }
}

