/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing.opentelemetry;

import io.grpc.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.trace.Tracer;
import io.opentelemetry.trace.TracingContextUtils;
import java.util.function.BiFunction;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.tracing.Propagator;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryContext;

class OpenTelemetryPropagator
implements Propagator {
    private final Tracer tracer;
    private final TextMapPropagator httpTextFormat;

    OpenTelemetryPropagator(Tracer tracer, TextMapPropagator httpTextFormat) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.httpTextFormat = (TextMapPropagator)Require.nonNull((String)"HTTP text injector/extractor", (Object)httpTextFormat);
    }

    @Override
    public <C> void inject(TraceContext toInject, C carrier, Propagator.Setter<C> setter) {
        Require.nonNull((String)"Trace context to inject to", (Object)toInject);
        Require.nonNull((String)"Carrier", carrier);
        Require.nonNull((String)"Setter", setter);
        Require.argument((String)"Trace context", (Object)toInject).instanceOf(OpenTelemetryContext.class);
        this.httpTextFormat.inject(((OpenTelemetryContext)toInject).getContext(), carrier, setter::set);
    }

    @Override
    public <C> OpenTelemetryContext extractContext(TraceContext existing, C carrier, BiFunction<C, String, String> getter) {
        Require.nonNull((String)"Trace context to extract from", (Object)existing);
        Require.nonNull((String)"Carrier", carrier);
        Require.nonNull((String)"Getter", getter);
        Require.argument((String)"Trace context", (Object)existing).instanceOf(OpenTelemetryContext.class);
        Context extracted = this.httpTextFormat.extract(((OpenTelemetryContext)existing).getContext(), carrier, getter::apply);
        String id = TracingContextUtils.getSpan((Context)extracted).getContext().getSpanIdAsHexString();
        if (DefaultSpan.getInvalid().getContext().getSpanIdAsHexString().equals(id)) {
            return (OpenTelemetryContext)existing;
        }
        return new OpenTelemetryContext(this.tracer, extracted);
    }
}

