/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.okhttp;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.BinaryMessage;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.CloseMessage;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Message;
import org.openqa.selenium.remote.http.TextMessage;
import org.openqa.selenium.remote.http.WebSocket;
import org.openqa.selenium.remote.http.okhttp.CreateOkClient;
import org.openqa.selenium.remote.http.okhttp.OkMessages;

class OkHttpWebSocket
implements WebSocket {
    private final okhttp3.WebSocket socket;

    private OkHttpWebSocket(OkHttpClient client, Request request, final WebSocket.Listener listener) {
        Require.nonNull((String)"HTTP client", (Object)client);
        Require.nonNull((String)"Request to send", (Object)request);
        Require.nonNull((String)"WebSocket listener", (Object)listener);
        this.socket = client.newWebSocket(request, new WebSocketListener(){

            public void onMessage(okhttp3.WebSocket webSocket, String text) {
                if (text != null) {
                    listener.onText((CharSequence)text);
                }
            }

            public void onClosed(okhttp3.WebSocket webSocket, int code, String reason) {
                listener.onClose(code, reason);
            }

            public void onFailure(okhttp3.WebSocket webSocket, Throwable t, Response response) {
                listener.onError(t);
            }
        });
    }

    static BiFunction<HttpRequest, WebSocket.Listener, WebSocket> create(ClientConfig config) {
        Filter filter = config.filter();
        Function<HttpRequest, HttpRequest> filterRequest = req -> {
            AtomicReference ref = new AtomicReference();
            filter.andFinally(in -> {
                ref.set(in);
                return new HttpResponse();
            }).execute(req);
            return (HttpRequest)ref.get();
        };
        OkHttpClient client = new CreateOkClient().apply(config);
        return (req, listener) -> {
            HttpRequest filtered = (HttpRequest)filterRequest.apply((HttpRequest)req);
            Request okReq = OkMessages.toOkHttpRequest(config.baseUri(), filtered);
            return new OkHttpWebSocket(client, okReq, (WebSocket.Listener)listener);
        };
    }

    public WebSocket send(Message message) {
        if (message instanceof BinaryMessage) {
            byte[] data = ((BinaryMessage)message).data();
            this.socket.send(ByteString.of((byte[])data, (int)0, (int)data.length));
        } else if (message instanceof CloseMessage) {
            this.socket.close(((CloseMessage)message).code(), ((CloseMessage)message).reason());
        } else if (message instanceof TextMessage) {
            this.socket.send(((TextMessage)message).text());
        }
        return this;
    }

    public void close() {
        this.socket.close(1000, "WebDriver closing socket");
    }
}

