/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.netty;

import java.util.function.BiFunction;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpClientName;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.WebSocket;
import org.openqa.selenium.remote.http.netty.NettyDomainSocketClient;
import org.openqa.selenium.remote.http.netty.NettyHttpHandler;
import org.openqa.selenium.remote.http.netty.NettyWebSocket;

public class NettyClient
implements HttpClient {
    private static final AsyncHttpClient httpClient = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)new DefaultAsyncHttpClientConfig.Builder().setAggregateWebSocketFrameFragments(true).setWebSocketMaxBufferSize(Integer.MAX_VALUE).setWebSocketMaxFrameSize(Integer.MAX_VALUE));
    private final HttpHandler handler;
    private BiFunction<HttpRequest, WebSocket.Listener, WebSocket> toWebSocket;

    private NettyClient(HttpHandler handler, BiFunction<HttpRequest, WebSocket.Listener, WebSocket> toWebSocket) {
        this.handler = (HttpHandler)Require.nonNull((String)"Handler", (Object)handler);
        this.toWebSocket = (BiFunction)Require.nonNull((String)"WebSocket creation function", toWebSocket);
    }

    public HttpResponse execute(HttpRequest request) {
        return this.handler.execute(request);
    }

    public WebSocket openSocket(HttpRequest request, WebSocket.Listener listener) {
        Require.nonNull((String)"Request to send", (Object)request);
        Require.nonNull((String)"WebSocket listener", (Object)listener);
        return this.toWebSocket.apply(request, listener);
    }

    public HttpClient with(Filter filter) {
        Require.nonNull((String)"Filter", (Object)filter);
        return new NettyClient(this.handler.with(filter), this.toWebSocket);
    }

    @HttpClientName(value="netty")
    public static class Factory
    implements HttpClient.Factory {
        public HttpClient createClient(ClientConfig config) {
            Require.nonNull((String)"Client config", (Object)config);
            if ("unix".equals(config.baseUri().getScheme())) {
                return new NettyDomainSocketClient(config);
            }
            return new NettyClient(new NettyHttpHandler(config, httpClient).with(config.filter()), NettyWebSocket.create(config, httpClient));
        }
    }
}

