/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Beta;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WindowType;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.LoggingHandler;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.logging.Logs;
import org.openqa.selenium.logging.NeedsLocalLogs;
import org.openqa.selenium.remote.Augmentable;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandPayload;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.JsonToWebElementConverter;
import org.openqa.selenium.remote.RemoteExecuteMethod;
import org.openqa.selenium.remote.RemoteKeyboard;
import org.openqa.selenium.remote.RemoteLogs;
import org.openqa.selenium.remote.RemoteMouse;
import org.openqa.selenium.remote.RemoteWebDriverBuilder;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.remote.UselessFileDetector;
import org.openqa.selenium.remote.internal.WebElementToJsonConverter;
import org.openqa.selenium.virtualauthenticator.Credential;
import org.openqa.selenium.virtualauthenticator.HasVirtualAuthenticator;
import org.openqa.selenium.virtualauthenticator.VirtualAuthenticator;
import org.openqa.selenium.virtualauthenticator.VirtualAuthenticatorOptions;

@Augmentable
public class RemoteWebDriver
implements WebDriver,
JavascriptExecutor,
FindsById,
FindsByClassName,
FindsByLinkText,
FindsByName,
FindsByCssSelector,
FindsByTagName,
FindsByXPath,
HasInputDevices,
HasCapabilities,
Interactive,
TakesScreenshot,
HasVirtualAuthenticator {
    private static final Logger logger = Logger.getLogger(RemoteWebDriver.class.getName());
    private Level level = Level.FINE;
    private ErrorHandler errorHandler = new ErrorHandler();
    private CommandExecutor executor;
    private Capabilities capabilities;
    private SessionId sessionId;
    private FileDetector fileDetector = new UselessFileDetector();
    private ExecuteMethod executeMethod;
    private JsonToWebElementConverter converter;
    private RemoteKeyboard keyboard;
    private RemoteMouse mouse;
    private Logs remoteLogs;
    private LocalLogs localLogs;

    protected RemoteWebDriver() {
        this.init((Capabilities)new ImmutableCapabilities());
    }

    public RemoteWebDriver(Capabilities capabilities) {
        this((URL)null, capabilities);
    }

    public RemoteWebDriver(CommandExecutor executor, Capabilities capabilities) {
        this.executor = executor;
        this.init(capabilities);
        if (executor instanceof NeedsLocalLogs) {
            ((NeedsLocalLogs)executor).setLocalLogs(this.localLogs);
        }
        try {
            this.startSession(capabilities);
        }
        catch (RuntimeException e) {
            try {
                this.quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities capabilities) {
        this(new HttpCommandExecutor(remoteAddress), capabilities);
    }

    @Beta
    public static RemoteWebDriverBuilder builder() {
        return new RemoteWebDriverBuilder();
    }

    private void init(Capabilities capabilities) {
        capabilities = capabilities == null ? new ImmutableCapabilities() : capabilities;
        logger.addHandler((Handler)LoggingHandler.getInstance());
        this.converter = new JsonToWebElementConverter(this);
        this.executeMethod = new RemoteExecuteMethod(this);
        this.keyboard = new RemoteKeyboard(this.executeMethod);
        this.mouse = new RemoteMouse(this.executeMethod);
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        boolean isProfilingEnabled = capabilities.is("webdriver.logging.profiler.enabled");
        if (isProfilingEnabled) {
            builder.add((Object)"profiler");
        }
        LoggingPreferences mergedLoggingPrefs = new LoggingPreferences();
        mergedLoggingPrefs.addPreferences((LoggingPreferences)capabilities.getCapability("loggingPrefs"));
        if (!mergedLoggingPrefs.getEnabledLogTypes().contains("client") || mergedLoggingPrefs.getLevel("client") != Level.OFF) {
            builder.add((Object)"client");
        }
        ImmutableSet logTypesToInclude = builder.build();
        LocalLogs performanceLogger = LocalLogs.getStoringLoggerInstance((Set)logTypesToInclude);
        LocalLogs clientLogs = LocalLogs.getHandlerBasedLoggerInstance((LoggingHandler)LoggingHandler.getInstance(), (Set)logTypesToInclude);
        this.localLogs = LocalLogs.getCombinedLogsHolder((LocalLogs)clientLogs, (LocalLogs)performanceLogger);
        this.remoteLogs = new RemoteLogs(this.executeMethod, this.localLogs);
    }

    public void setFileDetector(FileDetector detector) {
        if (detector == null) {
            throw new WebDriverException("You may not set a file detector that is null");
        }
        this.fileDetector = detector;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    protected void setSessionId(String opaqueKey) {
        this.sessionId = new SessionId(opaqueKey);
    }

    protected void startSession(Capabilities capabilities) {
        Platform platform;
        Response response = this.execute(DriverCommand.NEW_SESSION(capabilities));
        Map rawCapabilities = (Map)response.getValue();
        MutableCapabilities returnedCapabilities = new MutableCapabilities();
        for (Map.Entry entry : rawCapabilities.entrySet()) {
            if ("platform".equals(entry.getKey()) || "platformName".equals(entry.getKey())) continue;
            returnedCapabilities.setCapability((String)entry.getKey(), entry.getValue());
        }
        String platformString = (String)rawCapabilities.getOrDefault("platform", rawCapabilities.get("platformName"));
        try {
            platform = platformString == null || "".equals(platformString) ? Platform.ANY : Platform.fromString((String)platformString);
        }
        catch (WebDriverException e) {
            platform = Platform.extractFromSysProperty((String)platformString);
        }
        returnedCapabilities.setCapability("platform", platform);
        returnedCapabilities.setCapability("platformName", platform);
        if (rawCapabilities.containsKey("javascriptEnabled")) {
            Object raw = rawCapabilities.get("javascriptEnabled");
            if (raw instanceof String) {
                returnedCapabilities.setCapability("javascriptEnabled", Boolean.parseBoolean((String)raw));
            } else if (raw instanceof Boolean) {
                returnedCapabilities.setCapability("javascriptEnabled", ((Boolean)raw).booleanValue());
            }
        } else {
            returnedCapabilities.setCapability("javascriptEnabled", true);
        }
        this.capabilities = returnedCapabilities;
        this.sessionId = new SessionId(response.getSessionId());
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public CommandExecutor getCommandExecutor() {
        return this.executor;
    }

    protected void setCommandExecutor(CommandExecutor executor) {
        this.executor = executor;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void get(String url) {
        this.execute(DriverCommand.GET(url));
    }

    public String getTitle() {
        Response response = this.execute("getTitle");
        Object value = response.getValue();
        return value == null ? "" : value.toString();
    }

    public String getCurrentUrl() {
        Response response = this.execute("getCurrentUrl");
        if (response == null || response.getValue() == null) {
            throw new WebDriverException("Remote browser did not respond to getCurrentUrl");
        }
        return response.getValue().toString();
    }

    public <X> X getScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        Response response = this.execute("screenshot");
        Object result = response.getValue();
        if (result instanceof String) {
            String base64EncodedPng = (String)result;
            return (X)outputType.convertFromBase64Png(base64EncodedPng);
        }
        if (result instanceof byte[]) {
            String base64EncodedPng = new String((byte[])result);
            return (X)outputType.convertFromBase64Png(base64EncodedPng);
        }
        throw new RuntimeException(String.format("Unexpected result for %s command: %s", "screenshot", result == null ? "null" : result.getClass().getName() + " instance"));
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    protected WebElement findElement(String by, String using) {
        WebElement element;
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the selector is null.");
        }
        Response response = this.execute(DriverCommand.FIND_ELEMENT(by, using));
        Object value = response.getValue();
        if (value == null) {
            throw new NoSuchElementException(String.format("Cannot locate an element using %s=%s", by, using));
        }
        try {
            element = (WebElement)value;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to WebElement: " + value, (Throwable)ex);
        }
        this.setFoundBy((SearchContext)this, element, by, using);
        return element;
    }

    protected void setFoundBy(SearchContext context, WebElement element, String by, String using) {
        if (element instanceof RemoteWebElement) {
            RemoteWebElement remoteElement = (RemoteWebElement)element;
            remoteElement.setFoundBy(context, by, using);
            remoteElement.setFileDetector(this.getFileDetector());
        }
    }

    protected List<WebElement> findElements(String by, String using) {
        List allElements;
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the selector is null.");
        }
        Response response = this.execute(DriverCommand.FIND_ELEMENTS(by, using));
        Object value = response.getValue();
        if (value == null) {
            return Collections.emptyList();
        }
        try {
            allElements = (List)value;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to List<WebElement>: " + value, (Throwable)ex);
        }
        for (WebElement element : allElements) {
            this.setFoundBy((SearchContext)this, element, by, using);
        }
        return allElements;
    }

    public WebElement findElementById(String using) {
        return this.findElement("id", using);
    }

    public List<WebElement> findElementsById(String using) {
        return this.findElements("id", using);
    }

    public WebElement findElementByLinkText(String using) {
        return this.findElement("link text", using);
    }

    public List<WebElement> findElementsByLinkText(String using) {
        return this.findElements("link text", using);
    }

    public WebElement findElementByPartialLinkText(String using) {
        return this.findElement("partial link text", using);
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        return this.findElements("partial link text", using);
    }

    public WebElement findElementByTagName(String using) {
        return this.findElement("tag name", using);
    }

    public List<WebElement> findElementsByTagName(String using) {
        return this.findElements("tag name", using);
    }

    public WebElement findElementByName(String using) {
        return this.findElement("name", using);
    }

    public List<WebElement> findElementsByName(String using) {
        return this.findElements("name", using);
    }

    public WebElement findElementByClassName(String using) {
        return this.findElement("class name", using);
    }

    public List<WebElement> findElementsByClassName(String using) {
        return this.findElements("class name", using);
    }

    public WebElement findElementByCssSelector(String using) {
        return this.findElement("css selector", using);
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        return this.findElements("css selector", using);
    }

    public WebElement findElementByXPath(String using) {
        return this.findElement("xpath", using);
    }

    public List<WebElement> findElementsByXPath(String using) {
        return this.findElements("xpath", using);
    }

    public String getPageSource() {
        return (String)this.execute("getPageSource").getValue();
    }

    public void close() {
        this.execute("close");
    }

    public void quit() {
        if (this.sessionId == null) {
            return;
        }
        try {
            this.execute("quit");
        }
        finally {
            this.sessionId = null;
        }
    }

    public Set<String> getWindowHandles() {
        Response response = this.execute("getWindowHandles");
        Object value = response.getValue();
        try {
            List returnedValues = (List)value;
            return new LinkedHashSet<String>(returnedValues);
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to List<String>: " + value, (Throwable)ex);
        }
    }

    public String getWindowHandle() {
        return String.valueOf(this.execute("getCurrentWindowHandle").getValue());
    }

    public Object executeScript(String script, Object ... args) {
        if (!this.isJavascriptEnabled()) {
            throw new UnsupportedOperationException("You must be using an underlying instance of WebDriver that supports executing javascript");
        }
        script = script.replaceAll("\"", "\\\"");
        List<Object> convertedArgs = Stream.of(args).map(new WebElementToJsonConverter()).collect(Collectors.toList());
        return this.execute(DriverCommand.EXECUTE_SCRIPT(script, convertedArgs)).getValue();
    }

    public Object executeAsyncScript(String script, Object ... args) {
        if (!this.isJavascriptEnabled()) {
            throw new UnsupportedOperationException("You must be using an underlying instance of WebDriver that supports executing javascript");
        }
        script = script.replaceAll("\"", "\\\"");
        List<Object> convertedArgs = Stream.of(args).map(new WebElementToJsonConverter()).collect(Collectors.toList());
        return this.execute(DriverCommand.EXECUTE_ASYNC_SCRIPT(script, convertedArgs)).getValue();
    }

    private boolean isJavascriptEnabled() {
        return this.capabilities.is("javascriptEnabled");
    }

    public WebDriver.TargetLocator switchTo() {
        return new RemoteTargetLocator();
    }

    public WebDriver.Navigation navigate() {
        return new RemoteNavigation();
    }

    public WebDriver.Options manage() {
        return new RemoteWebDriverOptions();
    }

    protected void setElementConverter(JsonToWebElementConverter converter) {
        this.converter = (JsonToWebElementConverter)Require.nonNull((String)"Element converter", (Object)converter);
    }

    protected JsonToWebElementConverter getElementConverter() {
        return this.converter;
    }

    public void setLogLevel(Level level) {
        this.level = level;
    }

    protected Response execute(CommandPayload payload) {
        Response response;
        Command command = new Command(this.sessionId, payload);
        long start = System.currentTimeMillis();
        String currentName = Thread.currentThread().getName();
        Thread.currentThread().setName(String.format("Forwarding %s on session %s to remote", command.getName(), this.sessionId));
        try {
            this.log(this.sessionId, command.getName(), command, When.BEFORE);
            response = this.executor.execute(command);
            this.log(this.sessionId, command.getName(), response, When.AFTER);
            if (response == null) {
                Response response2 = null;
                return response2;
            }
            Object value = this.getElementConverter().apply(response.getValue());
            response.setValue(value);
        }
        catch (WebDriverException e) {
            throw e;
        }
        catch (Exception e) {
            this.log(this.sessionId, command.getName(), command, When.EXCEPTION);
            String errorMessage = "Error communicating with the remote browser. It may have died.";
            if (command.getName().equals("newSession")) {
                errorMessage = "Could not start a new session. Possible causes are invalid address of the remote server or browser start-up failure.";
            }
            UnreachableBrowserException ube = new UnreachableBrowserException(errorMessage, e);
            if (this.getSessionId() != null) {
                ube.addInfo("Session ID", this.getSessionId().toString());
            }
            if (this.getCapabilities() != null) {
                ube.addInfo("Capabilities", this.getCapabilities().toString());
            }
            throw ube;
        }
        finally {
            Thread.currentThread().setName(currentName);
        }
        try {
            this.errorHandler.throwIfResponseFailed(response, System.currentTimeMillis() - start);
        }
        catch (WebDriverException ex) {
            if (command.getParameters() != null && command.getParameters().containsKey("using") && command.getParameters().containsKey("value")) {
                ex.addInfo("*** Element info", String.format("{Using=%s, value=%s}", command.getParameters().get("using"), command.getParameters().get("value")));
            }
            ex.addInfo("Driver info", this.getClass().getName());
            if (this.getSessionId() != null) {
                ex.addInfo("Session ID", this.getSessionId().toString());
            }
            if (this.getCapabilities() != null) {
                ex.addInfo("Capabilities", this.getCapabilities().toString());
            }
            throw ex;
        }
        return response;
    }

    protected Response execute(String driverCommand, Map<String, ?> parameters) {
        return this.execute(new CommandPayload(driverCommand, parameters));
    }

    protected Response execute(String command) {
        return this.execute(command, (Map<String, ?>)ImmutableMap.of());
    }

    protected ExecuteMethod getExecuteMethod() {
        return this.executeMethod;
    }

    public void perform(Collection<Sequence> actions) {
        this.execute(DriverCommand.ACTIONS(actions));
    }

    public void resetInputState() {
        this.execute("clearActionState");
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    public Mouse getMouse() {
        return this.mouse;
    }

    public VirtualAuthenticator addVirtualAuthenticator(VirtualAuthenticatorOptions options) {
        String authenticatorId = (String)this.execute("addVirtualAuthenticator", options.toMap()).getValue();
        return new RemoteVirtualAuthenticator(authenticatorId);
    }

    public void removeVirtualAuthenticator(VirtualAuthenticator authenticator) {
        this.execute("removeVirtualAuthenticator", (Map<String, ?>)ImmutableMap.of((Object)"authenticatorId", (Object)authenticator.getId()));
    }

    protected void log(SessionId sessionId, String commandName, Object toLog, When when) {
        if (!logger.isLoggable(this.level)) {
            return;
        }
        String text = String.valueOf(toLog);
        if ((commandName.equals("executeScript") || commandName.equals("executeAsyncScript")) && text.length() > 100 && Boolean.getBoolean("webdriver.remote.shorten_log_messages")) {
            text = text.substring(0, 100) + "...";
        }
        switch (when) {
            case BEFORE: {
                logger.log(this.level, "Executing: " + commandName + " " + text);
                break;
            }
            case AFTER: {
                logger.log(this.level, "Executed: " + text);
                break;
            }
            case EXCEPTION: {
                logger.log(this.level, "Exception: " + text);
                break;
            }
            default: {
                logger.log(this.level, text);
            }
        }
    }

    public FileDetector getFileDetector() {
        return this.fileDetector;
    }

    public String toString() {
        Capabilities caps = this.getCapabilities();
        if (caps == null) {
            return super.toString();
        }
        Object platform = caps.getCapability("platformName");
        if (!(platform instanceof String)) {
            platform = caps.getCapability("platform");
        }
        if (platform == null) {
            platform = "unknown";
        }
        return String.format("%s: %s on %s (%s)", this.getClass().getSimpleName(), caps.getBrowserName(), platform, this.getSessionId());
    }

    public static enum When {
        BEFORE,
        AFTER,
        EXCEPTION;

    }

    private class RemoteVirtualAuthenticator
    implements VirtualAuthenticator {
        private final String id;

        public RemoteVirtualAuthenticator(String id) {
            this.id = (String)Require.nonNull((String)"Id", (Object)id);
        }

        public String getId() {
            return this.id;
        }

        public void addCredential(Credential credential) {
            RemoteWebDriver.this.execute("addCredential", (Map<String, ?>)new ImmutableMap.Builder().putAll(credential.toMap()).put((Object)"authenticatorId", (Object)this.id).build());
        }

        public List<Credential> getCredentials() {
            List response = (List)RemoteWebDriver.this.execute("getCredentials", (Map<String, ?>)ImmutableMap.of((Object)"authenticatorId", (Object)this.id)).getValue();
            return response.stream().map(Credential::fromMap).collect(Collectors.toList());
        }

        public void removeCredential(byte[] credentialId) {
            this.removeCredential(Base64.getUrlEncoder().encodeToString(credentialId));
        }

        public void removeCredential(String credentialId) {
            RemoteWebDriver.this.execute("removeCredential", (Map<String, ?>)ImmutableMap.of((Object)"authenticatorId", (Object)this.id, (Object)"credentialId", (Object)credentialId)).getValue();
        }

        public void removeAllCredentials() {
            RemoteWebDriver.this.execute("removeAllCredentials", (Map<String, ?>)ImmutableMap.of((Object)"authenticatorId", (Object)this.id));
        }

        public void setUserVerified(boolean verified) {
            RemoteWebDriver.this.execute("setUserVerified", (Map<String, ?>)ImmutableMap.of((Object)"authenticatorId", (Object)this.id, (Object)"isUserVerified", (Object)verified));
        }
    }

    private class RemoteAlert
    implements Alert {
        public void dismiss() {
            RemoteWebDriver.this.execute("dismissAlert");
        }

        public void accept() {
            RemoteWebDriver.this.execute("acceptAlert");
        }

        public String getText() {
            return (String)RemoteWebDriver.this.execute("getAlertText").getValue();
        }

        public void sendKeys(String keysToSend) {
            if (keysToSend == null) {
                throw new IllegalArgumentException("Keys to send should be a not null CharSequence");
            }
            RemoteWebDriver.this.execute(DriverCommand.SET_ALERT_VALUE(keysToSend));
        }
    }

    protected class RemoteTargetLocator
    implements WebDriver.TargetLocator {
        protected RemoteTargetLocator() {
        }

        public WebDriver frame(int frameIndex) {
            RemoteWebDriver.this.execute(DriverCommand.SWITCH_TO_FRAME(frameIndex));
            return RemoteWebDriver.this;
        }

        public WebDriver frame(String frameName) {
            String name = frameName.replaceAll("(['\"\\\\#.:;,!?+<>=~*^$|%&@`{}\\-/\\[\\]\\(\\)])", "\\\\$1");
            List<WebElement> frameElements = RemoteWebDriver.this.findElements(By.cssSelector((String)("frame[name='" + name + "'],iframe[name='" + name + "']")));
            if (frameElements.size() == 0) {
                frameElements = RemoteWebDriver.this.findElements(By.cssSelector((String)("frame#" + name + ",iframe#" + name)));
            }
            if (frameElements.size() == 0) {
                throw new NoSuchFrameException("No frame element found by name or id " + frameName);
            }
            return this.frame(frameElements.get(0));
        }

        public WebDriver frame(WebElement frameElement) {
            Object elementAsJson = new WebElementToJsonConverter().apply(frameElement);
            RemoteWebDriver.this.execute(DriverCommand.SWITCH_TO_FRAME(elementAsJson));
            return RemoteWebDriver.this;
        }

        public WebDriver parentFrame() {
            RemoteWebDriver.this.execute("switchToParentFrame");
            return RemoteWebDriver.this;
        }

        public WebDriver window(String windowHandleOrName) {
            try {
                RemoteWebDriver.this.execute(DriverCommand.SWITCH_TO_WINDOW(windowHandleOrName));
                return RemoteWebDriver.this;
            }
            catch (NoSuchWindowException nsw) {
                String original = RemoteWebDriver.this.getWindowHandle();
                for (String handle : RemoteWebDriver.this.getWindowHandles()) {
                    RemoteWebDriver.this.switchTo().window(handle);
                    if (!windowHandleOrName.equals(RemoteWebDriver.this.executeScript("return window.name", new Object[0]))) continue;
                    return RemoteWebDriver.this;
                }
                RemoteWebDriver.this.switchTo().window(original);
                throw nsw;
            }
        }

        public WebDriver newWindow(WindowType typeHint) {
            String original = RemoteWebDriver.this.getWindowHandle();
            try {
                Response response = RemoteWebDriver.this.execute(DriverCommand.SWITCH_TO_NEW_WINDOW(typeHint));
                String newWindowHandle = ((Map)response.getValue()).get("handle").toString();
                RemoteWebDriver.this.switchTo().window(newWindowHandle);
                return RemoteWebDriver.this;
            }
            catch (WebDriverException ex) {
                RemoteWebDriver.this.switchTo().window(original);
                throw ex;
            }
        }

        public WebDriver defaultContent() {
            RemoteWebDriver.this.execute(DriverCommand.SWITCH_TO_FRAME(null));
            return RemoteWebDriver.this;
        }

        public WebElement activeElement() {
            Response response = RemoteWebDriver.this.execute("getActiveElement");
            return (WebElement)response.getValue();
        }

        public Alert alert() {
            RemoteWebDriver.this.execute("getAlertText");
            return new RemoteAlert();
        }
    }

    private class RemoteNavigation
    implements WebDriver.Navigation {
        private RemoteNavigation() {
        }

        public void back() {
            RemoteWebDriver.this.execute("goBack");
        }

        public void forward() {
            RemoteWebDriver.this.execute("goForward");
        }

        public void to(String url) {
            RemoteWebDriver.this.get(url);
        }

        public void to(URL url) {
            RemoteWebDriver.this.get(String.valueOf(url));
        }

        public void refresh() {
            RemoteWebDriver.this.execute("refresh");
        }
    }

    protected class RemoteWebDriverOptions
    implements WebDriver.Options {
        protected RemoteWebDriverOptions() {
        }

        @Beta
        public Logs logs() {
            return RemoteWebDriver.this.remoteLogs;
        }

        public void addCookie(Cookie cookie) {
            cookie.validate();
            RemoteWebDriver.this.execute(DriverCommand.ADD_COOKIE(cookie));
        }

        public void deleteCookieNamed(String name) {
            RemoteWebDriver.this.execute(DriverCommand.DELETE_COOKIE(name));
        }

        public void deleteCookie(Cookie cookie) {
            this.deleteCookieNamed(cookie.getName());
        }

        public void deleteAllCookies() {
            RemoteWebDriver.this.execute("deleteAllCookies");
        }

        public Set<Cookie> getCookies() {
            Object returned = RemoteWebDriver.this.execute("getCookies").getValue();
            HashSet<Cookie> toReturn = new HashSet<Cookie>();
            if (!(returned instanceof Collection)) {
                return toReturn;
            }
            ((Collection)returned).stream().map(o -> (Map)o).map(rawCookie -> {
                Cookie.Builder builder = new Cookie.Builder((String)rawCookie.get("name"), (String)rawCookie.get("value")).path((String)rawCookie.get("path")).domain((String)rawCookie.get("domain")).isSecure(rawCookie.containsKey("secure") && (Boolean)rawCookie.get("secure") != false).isHttpOnly(rawCookie.containsKey("httpOnly") && (Boolean)rawCookie.get("httpOnly") != false).sameSite((String)rawCookie.get("sameSite"));
                Number expiryNum = (Number)rawCookie.get("expiry");
                builder.expiresOn(expiryNum == null ? null : new Date(TimeUnit.SECONDS.toMillis(expiryNum.longValue())));
                return builder.build();
            }).forEach(toReturn::add);
            return toReturn;
        }

        public Cookie getCookieNamed(String name) {
            Set<Cookie> allCookies = this.getCookies();
            for (Cookie cookie : allCookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
            return null;
        }

        public WebDriver.Timeouts timeouts() {
            return new RemoteTimeouts();
        }

        public WebDriver.ImeHandler ime() {
            return new RemoteInputMethodManager();
        }

        @Beta
        public WebDriver.Window window() {
            return new RemoteWindow();
        }

        @Beta
        protected class RemoteWindow
        implements WebDriver.Window {
            Map<String, Object> rawPoint;

            protected RemoteWindow() {
            }

            public void setSize(Dimension targetSize) {
                RemoteWebDriver.this.execute(DriverCommand.SET_CURRENT_WINDOW_SIZE(targetSize));
            }

            public void setPosition(Point targetPosition) {
                RemoteWebDriver.this.execute(DriverCommand.SET_CURRENT_WINDOW_POSITION(targetPosition));
            }

            public Dimension getSize() {
                Response response = RemoteWebDriver.this.execute("getCurrentWindowSize");
                Map rawSize = (Map)response.getValue();
                int width = ((Number)rawSize.get("width")).intValue();
                int height = ((Number)rawSize.get("height")).intValue();
                return new Dimension(width, height);
            }

            public Point getPosition() {
                Response response = RemoteWebDriver.this.execute(DriverCommand.GET_CURRENT_WINDOW_POSITION());
                this.rawPoint = (Map)response.getValue();
                int x = ((Number)this.rawPoint.get("x")).intValue();
                int y = ((Number)this.rawPoint.get("y")).intValue();
                return new Point(x, y);
            }

            public void maximize() {
                RemoteWebDriver.this.execute("maximizeCurrentWindow");
            }

            public void minimize() {
                RemoteWebDriver.this.execute("minimizeCurrentWindow");
            }

            public void fullscreen() {
                RemoteWebDriver.this.execute("fullscreenCurrentWindow");
            }
        }

        protected class RemoteTimeouts
        implements WebDriver.Timeouts {
            protected RemoteTimeouts() {
            }

            public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
                RemoteWebDriver.this.execute(DriverCommand.SET_IMPLICIT_WAIT_TIMEOUT(time, unit));
                return this;
            }

            public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
                RemoteWebDriver.this.execute(DriverCommand.SET_SCRIPT_TIMEOUT(time, unit));
                return this;
            }

            public WebDriver.Timeouts pageLoadTimeout(long time, TimeUnit unit) {
                RemoteWebDriver.this.execute(DriverCommand.SET_PAGE_LOAD_TIMEOUT(time, unit));
                return this;
            }
        }

        protected class RemoteInputMethodManager
        implements WebDriver.ImeHandler {
            protected RemoteInputMethodManager() {
            }

            public List<String> getAvailableEngines() {
                Response response = RemoteWebDriver.this.execute("imeGetAvailableEngines");
                return (List)response.getValue();
            }

            public String getActiveEngine() {
                Response response = RemoteWebDriver.this.execute("imeGetActiveEngine");
                return (String)response.getValue();
            }

            public boolean isActivated() {
                Response response = RemoteWebDriver.this.execute("imeIsActivated");
                return (Boolean)response.getValue();
            }

            public void deactivate() {
                RemoteWebDriver.this.execute("imeDeactivate");
            }

            public void activateEngine(String engine) {
                RemoteWebDriver.this.execute(DriverCommand.IME_ACTIVATE_ENGINE(engine));
            }
        }
    }
}

