/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AddRotatable;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.html5.AddApplicationCache;
import org.openqa.selenium.remote.html5.AddLocationContext;
import org.openqa.selenium.remote.html5.AddWebStorage;
import org.openqa.selenium.remote.mobile.AddNetworkConnection;

public abstract class BaseAugmenter {
    private final Map<Predicate<Capabilities>, AugmenterProvider> driverAugmentors = new HashMap<Predicate<Capabilities>, AugmenterProvider>();
    private final Map<Predicate<Capabilities>, AugmenterProvider> elementAugmentors = new HashMap<Predicate<Capabilities>, AugmenterProvider>();

    public BaseAugmenter() {
        this.addDriverAugmentation("locationContextEnabled", (AugmenterProvider)new AddLocationContext());
        this.addDriverAugmentation("applicationCacheEnabled", (AugmenterProvider)new AddApplicationCache());
        this.addDriverAugmentation("networkConnectionEnabled", (AugmenterProvider)new AddNetworkConnection());
        this.addDriverAugmentation("webStorageEnabled", (AugmenterProvider)new AddWebStorage());
        this.addDriverAugmentation("rotatable", (AugmenterProvider)new AddRotatable());
        StreamSupport.stream(ServiceLoader.load(AugmenterProvider.class).spliterator(), false).forEach(provider -> this.driverAugmentors.put(provider.isApplicable(), (AugmenterProvider)provider));
    }

    public void addDriverAugmentation(String capabilityName, AugmenterProvider handlerClass) {
        this.driverAugmentors.put(this.check(capabilityName), handlerClass);
    }

    public void addDriverAugmentation(Predicate<Capabilities> predicate, AugmenterProvider handlerClass) {
        Require.nonNull((String)"Predicate", predicate);
        Require.nonNull((String)"Handler class", (Object)handlerClass);
        this.driverAugmentors.put(predicate, handlerClass);
    }

    public void addElementAugmentation(String capabilityName, AugmenterProvider handlerClass) {
        this.elementAugmentors.put(this.check(capabilityName), handlerClass);
    }

    public void addElementAugmentation(Predicate<Capabilities> predicate, AugmenterProvider handlerClass) {
        Require.nonNull((String)"Predicate", predicate);
        Require.nonNull((String)"Handler class", (Object)handlerClass);
        this.elementAugmentors.put(predicate, handlerClass);
    }

    private Predicate<Capabilities> check(String capabilityName) {
        return caps -> {
            Require.nonNull((String)"Capability name", (Object)capabilityName);
            Object value = caps.getCapability(capabilityName);
            if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
                return false;
            }
            return value != null;
        };
    }

    public WebDriver augment(WebDriver driver) {
        RemoteWebDriver remoteDriver = this.extractRemoteWebDriver(driver);
        if (remoteDriver == null) {
            return driver;
        }
        return this.create(remoteDriver, this.driverAugmentors, driver);
    }

    public WebElement augment(RemoteWebElement element) {
        RemoteWebDriver parent = (RemoteWebDriver)element.getWrappedDriver();
        if (parent == null) {
            return element;
        }
        return this.create(parent, this.elementAugmentors, element);
    }

    protected abstract <X> X create(RemoteWebDriver var1, Map<Predicate<Capabilities>, AugmenterProvider> var2, X var3);

    protected abstract RemoteWebDriver extractRemoteWebDriver(WebDriver var1);
}

