/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import com.google.common.primitives.Primitives;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;

class NumberCoercer<T extends Number>
extends TypeCoercer<T> {
    private final Class<T> stereotype;
    private final Function<Number, T> mapper;

    NumberCoercer(Class<T> stereotype, Function<Number, T> mapper) {
        this.stereotype = Objects.requireNonNull(stereotype);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public boolean test(Class<?> type) {
        return this.stereotype.isAssignableFrom(Primitives.wrap(type));
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, T> apply(Type ignored) {
        return (jsonInput, setting) -> {
            Number number;
            switch (jsonInput.peek()) {
                case NUMBER: {
                    number = jsonInput.nextNumber();
                    break;
                }
                case STRING: {
                    try {
                        number = new BigDecimal(jsonInput.nextString());
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new JsonException(e);
                    }
                }
                default: {
                    throw new JsonException("Unable to coerce to a number: " + (Object)((Object)jsonInput.peek()));
                }
            }
            return (Number)this.mapper.apply(number);
        };
    }
}

