/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os;

import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.os.OsProcess;

@Deprecated
public class CommandLine {
    private final OsProcess process;

    public CommandLine(String executable, String ... args) {
        this.process = new OsProcess(executable, args);
    }

    public void setEnvironmentVariables(Map<String, String> environment) {
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            this.setEnvironmentVariable(entry.getKey(), entry.getValue());
        }
    }

    public void setEnvironmentVariable(String name, String value) {
        this.process.setEnvironmentVariable(name, value);
    }

    public void setDynamicLibraryPath(String newLibraryPath) {
        if (newLibraryPath != null) {
            this.setEnvironmentVariable(CommandLine.getLibraryPathPropertyName(), newLibraryPath);
        }
    }

    public void updateDynamicLibraryPath(String extraPath) {
        if (extraPath != null) {
            String existing = System.getenv(CommandLine.getLibraryPathPropertyName());
            String ldPath = existing != null ? existing + File.pathSeparator + extraPath : extraPath;
            this.setEnvironmentVariable(CommandLine.getLibraryPathPropertyName(), ldPath);
        }
    }

    public static String getLibraryPathPropertyName() {
        Platform current = Platform.getCurrent();
        if (current.is(Platform.WINDOWS)) {
            return "PATH";
        }
        if (current.is(Platform.MAC)) {
            return "DYLD_LIBRARY_PATH";
        }
        return "LD_LIBRARY_PATH";
    }

    public void executeAsync() {
        this.process.executeAsync();
    }

    public void execute() {
        this.executeAsync();
        this.waitFor();
    }

    public boolean waitForProcessStarted(long duration, TimeUnit unit) {
        return this.process.waitForProcessStarted(duration, unit);
    }

    public void waitFor() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WebDriverException((Throwable)e);
        }
    }

    public void waitFor(long timeout) {
        try {
            this.process.waitFor(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WebDriverException((Throwable)e);
        }
    }

    public boolean isSuccessful() {
        return 0 == this.getExitCode();
    }

    public int getExitCode() {
        return this.process.getExitCode();
    }

    public String getStdOut() {
        return this.process.getStdOut();
    }

    public int destroy() {
        return this.process.destroy();
    }

    public boolean isRunning() {
        return this.process.isRunning();
    }

    public void setInput(String allInput) {
        this.process.setInput(allInput);
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.process.setWorkingDirectory(new File(workingDirectory));
    }

    public String toString() {
        return this.process.toString();
    }

    public void copyOutputTo(OutputStream out) {
        this.process.copyOutputTo(out);
    }

    public void checkForError() {
        this.process.checkForError();
    }
}

