/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.manager;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Beta;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.manager.SeleniumManagerOutput;
import org.openqa.selenium.os.ExternalProcess;

@Beta
public class SeleniumManager {
    private static final Logger LOG = Logger.getLogger(SeleniumManager.class.getName());
    private static final String SELENIUM_MANAGER = "selenium-manager";
    private static final String DEFAULT_CACHE_PATH = "~/.cache/selenium";
    private static final String BINARY_PATH_FORMAT = "/manager/%s/%s";
    private static final String HOME = "~";
    private static final String CACHE_PATH_ENV = "SE_CACHE_PATH";
    private static final String BETA_PREFIX = "0.";
    private static final String EXE = ".exe";
    private static volatile SeleniumManager manager;
    private final String managerPath = System.getenv("SE_MANAGER_PATH");
    private Path binary = this.managerPath == null ? null : Paths.get(this.managerPath, new String[0]);
    private String seleniumManagerVersion;
    private boolean binaryInTemporalFolder = false;

    private SeleniumManager() {
        BuildInfo info = new BuildInfo();
        String releaseLabel = info.getReleaseLabel();
        int lastDot = releaseLabel.lastIndexOf(".");
        this.seleniumManagerVersion = BETA_PREFIX + releaseLabel.substring(0, lastDot);
        if (this.managerPath == null) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (this.binaryInTemporalFolder && this.binary != null && Files.exists(this.binary, new LinkOption[0])) {
                    try {
                        Files.delete(this.binary);
                    }
                    catch (IOException e) {
                        LOG.warning(String.format("%s deleting temporal file: %s", e.getClass().getSimpleName(), e.getMessage()));
                    }
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SeleniumManager getInstance() {
        if (manager != null) return manager;
        Class<SeleniumManager> clazz = SeleniumManager.class;
        synchronized (SeleniumManager.class) {
            if (manager != null) return manager;
            manager = new SeleniumManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    private static SeleniumManagerOutput.Result runCommand(Path binary, List<String> arguments) {
        String output;
        int code;
        LOG.fine(String.format("Executing Process: %s", arguments));
        try {
            ExternalProcess process = ExternalProcess.builder().command(binary.toAbsolutePath().toString(), arguments).start();
            if (!process.waitFor(Duration.ofHours(1L))) {
                LOG.warning("Selenium Manager did not exit, shutting it down");
                process.shutdown();
            }
            code = process.exitValue();
            output = process.getOutput();
        }
        catch (Exception e) {
            throw new WebDriverException("Failed to run command: " + arguments, (Throwable)e);
        }
        SeleniumManagerOutput jsonOutput = null;
        JsonException failedToParse = null;
        String dump = output;
        if (!output.isEmpty()) {
            try {
                jsonOutput = (SeleniumManagerOutput)new Json().toType(output, SeleniumManagerOutput.class);
                jsonOutput.getLogs().forEach(logged -> {
                    Level currentLevel = logged.getLevel() == Level.INFO ? Level.FINE : logged.getLevel();
                    LOG.log(currentLevel, logged.getMessage());
                });
                dump = jsonOutput.getResult().getMessage();
            }
            catch (JsonException e) {
                failedToParse = e;
            }
        }
        if (code != 0) {
            throw new WebDriverException("Command failed with code: " + code + ", executed: " + arguments + "\n" + dump, (Throwable)failedToParse);
        }
        if (failedToParse != null || jsonOutput == null) {
            throw new WebDriverException("Failed to parse json output, executed: " + arguments + "\n" + dump, (Throwable)failedToParse);
        }
        return jsonOutput.getResult();
    }

    /*
     * Unable to fully structure code
     */
    private synchronized Path getBinary() {
        if (this.binary == null) {
            try {
                current = Platform.getCurrent();
                folder = "linux";
                extension = "";
                if (current.is(Platform.WINDOWS)) {
                    extension = ".exe";
                    folder = "windows";
                } else if (current.is(Platform.MAC)) {
                    folder = "macos";
                }
                this.binary = this.getBinaryInCache("selenium-manager" + extension);
                if (this.binary.toFile().exists()) ** GOTO lbl34
                binaryPathInJar = String.format("%s/%s%s", new Object[]{folder, "selenium-manager", extension});
                inputStream = this.getClass().getResourceAsStream(binaryPathInJar);
                try {
                    this.binary.getParent().toFile().mkdirs();
                    Files.copy(inputStream, this.binary, new CopyOption[0]);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                this.binary.toFile().setExecutable(true);
            }
            catch (Exception e) {
                throw new WebDriverException("Unable to obtain Selenium Manager Binary", (Throwable)e);
            }
        } else if (!Files.exists(this.binary, new LinkOption[0])) {
            throw new WebDriverException(String.format("Unable to obtain Selenium Manager Binary at: %s", new Object[]{this.binary}));
        }
lbl34:
        // 4 sources

        this.binary.toFile().setExecutable(true);
        SeleniumManager.LOG.fine(String.format("Selenium Manager binary found at: %s", new Object[]{this.binary}));
        return this.binary;
    }

    private String getBrowserBinary(Capabilities options) {
        List<String> vendorOptionsCapabilities = Arrays.asList("moz:firefoxOptions", "goog:chromeOptions", "ms:edgeOptions");
        for (String vendorOptionsCapability : vendorOptionsCapabilities) {
            if (!options.asMap().containsKey(vendorOptionsCapability)) continue;
            try {
                Map vendorOptions = (Map)options.getCapability(vendorOptionsCapability);
                return (String)vendorOptions.get("binary");
            }
            catch (Exception e) {
                LOG.warning(String.format("Exception while retrieving the browser binary path. %s: %s", options, e.getMessage()));
            }
        }
        return null;
    }

    public SeleniumManagerOutput.Result getDriverPath(Capabilities options, boolean offline) {
        Proxy proxy;
        String browserBinary;
        Path binaryFile = this.getBinary();
        if (binaryFile == null) {
            return null;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--browser");
        arguments.add(options.getBrowserName());
        arguments.add("--output");
        arguments.add("json");
        if (!options.getBrowserVersion().isEmpty()) {
            arguments.add("--browser-version");
            arguments.add(options.getBrowserVersion());
            if (options instanceof MutableCapabilities) {
                ((MutableCapabilities)options).setCapability("browserVersion", (String)null);
            }
        }
        if ((browserBinary = this.getBrowserBinary(options)) != null && !browserBinary.isEmpty()) {
            arguments.add("--browser-path");
            arguments.add(browserBinary);
        }
        if (this.getLogLevel().intValue() <= Level.FINE.intValue()) {
            arguments.add("--debug");
        }
        if (offline) {
            arguments.add("--offline");
        }
        if ((proxy = Proxy.extractFrom((Capabilities)options)) != null) {
            if (proxy.getSslProxy() != null) {
                arguments.add("--proxy");
                arguments.add(proxy.getSslProxy());
            } else if (proxy.getHttpProxy() != null) {
                arguments.add("--proxy");
                arguments.add(proxy.getHttpProxy());
            }
        }
        SeleniumManagerOutput.Result result = SeleniumManager.runCommand(binaryFile, arguments);
        LOG.fine(String.format("Using driver at location: %s, browser at location %s", result.getDriverPath(), result.getBrowserPath()));
        return result;
    }

    private Level getLogLevel() {
        Level level = LOG.getLevel();
        if (level == null && LOG.getParent() != null) {
            level = LOG.getParent().getLevel();
        }
        if (level == null) {
            return Level.INFO;
        }
        return level;
    }

    private Path getBinaryInCache(String binaryName) throws IOException {
        Path cacheParent;
        String cachePath = DEFAULT_CACHE_PATH.replace(HOME, System.getProperty("user.home"));
        String cachePathEnv = System.getenv(CACHE_PATH_ENV);
        if (cachePathEnv != null) {
            cachePath = cachePathEnv;
        }
        if (!Files.isWritable(cacheParent = Paths.get(cachePath, new String[0]))) {
            cacheParent = Files.createTempDirectory(SELENIUM_MANAGER, new FileAttribute[0]);
            this.binaryInTemporalFolder = true;
        }
        return Paths.get(cacheParent.toString(), String.format(BINARY_PATH_FORMAT, this.seleniumManagerVersion, binaryName));
    }
}

