/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.function.BiFunction;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonType;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;

public class InstantCoercer
extends TypeCoercer<Instant> {
    @Override
    public boolean test(Class<?> aClass) {
        return Instant.class.isAssignableFrom(aClass);
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, Instant> apply(Type type) {
        return (jsonInput, setting) -> {
            JsonType token = jsonInput.peek();
            if (JsonType.NUMBER.equals((Object)token)) {
                return Instant.ofEpochMilli(jsonInput.nextNumber().longValue());
            }
            if (JsonType.STRING.equals((Object)token)) {
                String raw = jsonInput.nextString();
                try {
                    TemporalAccessor parsed = DateTimeFormatter.ISO_INSTANT.parse(raw);
                    return Instant.from(parsed);
                }
                catch (DateTimeParseException ignored) {
                    try {
                        return Instant.ofEpochMilli(new BigDecimal(raw).longValue());
                    }
                    catch (NumberFormatException e) {
                        throw new JsonException(raw + " does not look like an Instant");
                    }
                }
            }
            throw new JsonException("Unable to parse: " + String.valueOf(jsonInput.read((Type)((Object)Object.class))));
        };
    }
}

