/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;

abstract class HttpMessage<M extends HttpMessage<M>> {
    private final Multimap<String, String> headers = ArrayListMultimap.create();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private Supplier<InputStream> content = Contents.empty();

    HttpMessage() {
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public M setAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this.self();
    }

    public M removeAttribute(String key) {
        this.attributes.remove(key);
        return this.self();
    }

    public Iterable<String> getAttributeNames() {
        return ImmutableSet.copyOf(this.attributes.keySet());
    }

    public void forEachHeader(BiConsumer<String, String> action) {
        this.headers.forEach(action);
    }

    public Iterable<String> getHeaderNames() {
        return Collections.unmodifiableCollection(this.headers.keySet());
    }

    public Iterable<String> getHeaders(String name) {
        return this.headers.entries().stream().filter(e -> Objects.nonNull(e.getKey())).filter(e -> ((String)e.getKey()).equalsIgnoreCase(name.toLowerCase())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public String getHeader(String name) {
        return this.headers.entries().stream().filter(e -> Objects.nonNull(e.getKey())).filter(e -> ((String)e.getKey()).equalsIgnoreCase(name.toLowerCase())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public M setHeader(String name, String value) {
        return ((HttpMessage)this.removeHeader(name)).addHeader(name, value);
    }

    public M addHeader(String name, String value) {
        this.headers.put((Object)name, (Object)value);
        return this.self();
    }

    public M removeHeader(String name) {
        this.headers.keySet().removeIf(header -> header.equalsIgnoreCase(name));
        return this.self();
    }

    public Charset getContentEncoding() {
        Charset charset = StandardCharsets.UTF_8;
        try {
            String contentType = this.getHeader("Content-Type");
            if (contentType != null) {
                MediaType mediaType = MediaType.parse((String)contentType);
                charset = (Charset)mediaType.charset().or((Object)StandardCharsets.UTF_8);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return charset;
    }

    public M setContent(Supplier<InputStream> supplier) {
        this.content = (Supplier)Require.nonNull((String)"Supplier", supplier);
        return this.self();
    }

    public Supplier<InputStream> getContent() {
        return this.content;
    }

    private M self() {
        return (M)this;
    }
}

