/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.events.zeromq;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.openqa.selenium.events.Event;
import org.openqa.selenium.events.EventName;
import org.openqa.selenium.internal.Require;

class Topic {
    private final List<Consumer<Event>> listeners = new CopyOnWriteArrayList<Consumer<Event>>();
    private final EventName eventName;

    Topic(EventName forEventName) {
        this.eventName = (EventName)Require.nonNull((String)"Type", (Object)forEventName);
    }

    void addListener(Consumer<Event> listener) {
        this.listeners.add((Consumer)Require.nonNull((String)"Event listener", listener));
    }

    public void fire(Event event) {
        if (!this.eventName.equals(event.getType())) {
            return;
        }
        this.listeners.parallelStream().forEach(listener -> listener.accept(event));
    }
}

