/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.events;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import org.openqa.selenium.events.EventName;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;

public class Event {
    private static final Json JSON = new Json();
    private final UUID id;
    private final EventName eventName;
    private final String data;

    public Event(EventName eventName, Object data) {
        this(UUID.randomUUID(), eventName, data);
    }

    public Event(UUID id, EventName eventName, Object data) {
        this.id = (UUID)Require.nonNull((String)"Message id", (Object)id);
        this.eventName = (EventName)Require.nonNull((String)"Event type", (Object)eventName);
        StringBuilder builder = new StringBuilder();
        try (JsonOutput out = JSON.newOutput((Appendable)builder);){
            out.setPrettyPrint(false).writeClassName(false).write(data);
        }
        this.data = builder.toString();
    }

    public UUID getId() {
        return this.id;
    }

    public EventName getType() {
        return this.eventName;
    }

    public <T> T getData(Type typeOfT) {
        return (T)JSON.toType(this.data, typeOfT);
    }

    public String getRawData() {
        return this.data;
    }

    public String toString() {
        return new StringJoiner(", ", Event.class.getSimpleName() + "[", "]").add("id=" + this.id).add("type=" + this.eventName).add("data=" + this.data).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Event)) {
            return false;
        }
        Event that = (Event)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getRawData(), that.getRawData());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getType(), this.data);
    }
}

