/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.v1_41;

import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.docker.Container;
import org.openqa.selenium.docker.ContainerConfig;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.DockerProtocol;
import org.openqa.selenium.docker.v1_41.DockerMessages;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class CreateContainer {
    private static final Json JSON = new Json();
    private static final Logger LOG = Logger.getLogger(CreateContainer.class.getName());
    private final DockerProtocol protocol;
    private final HttpHandler client;

    public CreateContainer(DockerProtocol protocol, HttpHandler client) {
        this.protocol = (DockerProtocol)Require.nonNull((String)"Protocol", (Object)protocol);
        this.client = (HttpHandler)Require.nonNull((String)"HTTP client", (Object)client);
    }

    public Container apply(ContainerConfig info) {
        HttpResponse res = DockerMessages.throwIfNecessary(this.client.execute((HttpRequest)((HttpRequest)new HttpRequest(HttpMethod.POST, String.format("/v%s/containers/create", "1.41")).addHeader("Content-Type", "application/json; charset=utf-8")).setContent(Contents.asJson((Object)info))), "Unable to create container: ", info);
        try {
            Collection warnings;
            Map rawContainer = (Map)JSON.toType(Contents.string((HttpMessage)res), Json.MAP_TYPE);
            if (!(rawContainer.get("Id") instanceof String)) {
                throw new DockerException("Unable to read container id: " + rawContainer);
            }
            ContainerId id = new ContainerId((String)rawContainer.get("Id"));
            if (rawContainer.get("Warnings") instanceof Collection && (warnings = (Collection)rawContainer.get("Warnings")).size() > 0) {
                String allWarnings = warnings.stream().map(String::valueOf).collect(Collectors.joining("\n", " * ", ""));
                LOG.warning(String.format("Warnings while creating %s from %s: %s", id, info, allWarnings));
            }
            return new Container(this.protocol, id);
        }
        catch (NullPointerException | JsonException e) {
            throw new DockerException("Unable to create container from " + info);
        }
    }
}

