/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.remote;

import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.data.SessionRequest;
import org.openqa.selenium.grid.data.SessionRequestCapability;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.security.AddSecretFilter;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueueOptions;
import org.openqa.selenium.grid.web.Values;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.TypeToken;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.Tracer;

public class RemoteNewSessionQueue
extends NewSessionQueue {
    private static final Type QUEUE_CONTENTS_TYPE = new TypeToken<List<SessionRequestCapability>>(){}.getType();
    private static final Type SESSION_REQUEST_TYPE = new TypeToken<List<SessionRequest>>(){}.getType();
    private static final Json JSON = new Json();
    private final HttpClient client;
    private final Filter addSecret;

    public RemoteNewSessionQueue(Tracer tracer, HttpClient client, Secret registrationSecret) {
        super(tracer, registrationSecret);
        this.client = (HttpClient)Require.nonNull((String)"HTTP client", (Object)client);
        Require.nonNull((String)"Registration secret", (Object)registrationSecret);
        this.addSecret = new AddSecretFilter(registrationSecret);
    }

    public static NewSessionQueue create(Config config) {
        Tracer tracer = new LoggingOptions(config).getTracer();
        URI uri = new NewSessionQueueOptions(config).getSessionQueueUri();
        HttpClient.Factory clientFactory = new NetworkOptions(config).getHttpClientFactory(tracer);
        SecretOptions secretOptions = new SecretOptions(config);
        Secret registrationSecret = secretOptions.getRegistrationSecret();
        try {
            return new RemoteNewSessionQueue(tracer, clientFactory.createClient(uri.toURL()), registrationSecret);
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean peekEmpty() {
        return false;
    }

    @Override
    public HttpResponse addToQueue(SessionRequest request) {
        HttpRequest upstream = new HttpRequest(HttpMethod.POST, "/se/grid/newsessionqueue/session");
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)upstream);
        upstream.setContent(Contents.asJson((Object)request));
        return this.client.with(this.addSecret).execute(upstream);
    }

    @Override
    public boolean retryAddToQueue(SessionRequest request) {
        Require.nonNull((String)"Session request", (Object)request);
        HttpRequest upstream = new HttpRequest(HttpMethod.POST, String.format("/se/grid/newsessionqueue/session/%s/retry", request.getRequestId()));
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)upstream);
        upstream.setContent(Contents.asJson((Object)request));
        HttpResponse response = this.client.with(this.addSecret).execute(upstream);
        return (Boolean)Values.get(response, Boolean.class);
    }

    @Override
    public Optional<SessionRequest> remove(RequestId reqId) {
        HttpRequest upstream = new HttpRequest(HttpMethod.POST, "/se/grid/newsessionqueue/session/" + reqId);
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)upstream);
        HttpResponse response = this.client.with(this.addSecret).execute(upstream);
        if (response.isSuccessful()) {
            String rawValue = Contents.string((HttpMessage)response);
            if (rawValue == null || rawValue.trim().isEmpty()) {
                return Optional.empty();
            }
            return Optional.of((SessionRequest)JSON.toType(rawValue, SessionRequest.class));
        }
        return Optional.empty();
    }

    @Override
    public List<SessionRequest> getNextAvailable(Map<Capabilities, Long> stereotypes) {
        Require.nonNull((String)"Stereotypes", stereotypes);
        HashMap stereotypeJson = new HashMap();
        stereotypes.forEach((k, v) -> stereotypeJson.put(JSON.toJson(k), v));
        HttpRequest upstream = (HttpRequest)new HttpRequest(HttpMethod.POST, "/se/grid/newsessionqueue/session/next").setContent(Contents.asJson(stereotypeJson));
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)upstream);
        HttpResponse response = this.client.with(this.addSecret).execute(upstream);
        return (List)Values.get(response, SESSION_REQUEST_TYPE);
    }

    @Override
    public void complete(RequestId reqId, Either<SessionNotCreatedException, CreateSessionResponse> result) {
        Require.nonNull((String)"Request ID", (Object)reqId);
        Require.nonNull((String)"Result", result);
        HttpRequest upstream = result.isRight() ? (HttpRequest)new HttpRequest(HttpMethod.POST, String.format("/se/grid/newsessionqueue/session/%s/success", reqId)).setContent(Contents.asJson((Object)result.right())) : (HttpRequest)new HttpRequest(HttpMethod.POST, String.format("/se/grid/newsessionqueue/session/%s/failure", reqId)).setContent(Contents.asJson((Object)((SessionNotCreatedException)((Object)result.left())).getRawMessage()));
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)upstream);
        this.client.with(this.addSecret).execute(upstream);
    }

    @Override
    public int clearQueue() {
        HttpRequest upstream = new HttpRequest(HttpMethod.DELETE, "/se/grid/newsessionqueue/queue");
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)upstream);
        HttpResponse response = this.client.with(this.addSecret).execute(upstream);
        return (Integer)Values.get(response, Integer.class);
    }

    @Override
    public List<SessionRequestCapability> getQueueContents() {
        HttpRequest upstream = new HttpRequest(HttpMethod.GET, "/se/grid/newsessionqueue/queue");
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)upstream);
        HttpResponse response = this.client.execute(upstream);
        return (List)Values.get(response, QUEUE_CONTENTS_TYPE);
    }

    @Override
    public boolean isReady() {
        try {
            return this.client.execute(new HttpRequest(HttpMethod.GET, "/readyz")).isSuccessful();
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

