/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxCommandContext;
import org.openqa.selenium.firefox.HasContext;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AdditionalHttpCommands;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.http.HttpMethod;

@AutoService(value={AdditionalHttpCommands.class, AugmenterProvider.class})
public class AddHasContext
implements AugmenterProvider<HasContext>,
AdditionalHttpCommands {
    public static final String SET_CONTEXT = "setContext";
    public static final String GET_CONTEXT = "getContext";
    private static final Map<String, CommandInfo> COMMANDS = ImmutableMap.of((Object)"setContext", (Object)new CommandInfo("/session/:sessionId/moz/context", HttpMethod.POST), (Object)"getContext", (Object)new CommandInfo("/session/:sessionId/moz/context", HttpMethod.GET));

    public Map<String, CommandInfo> getAdditionalCommands() {
        return COMMANDS;
    }

    public Predicate<Capabilities> isApplicable() {
        return arg_0 -> ((Browser)Browser.FIREFOX).is(arg_0);
    }

    public Class<HasContext> getDescribedInterface() {
        return HasContext.class;
    }

    public HasContext getImplementation(Capabilities capabilities, final ExecuteMethod executeMethod) {
        return new HasContext(){

            @Override
            public void setContext(FirefoxCommandContext context) {
                Require.nonNull((String)"Firefox Command Context", (Object)((Object)context));
                executeMethod.execute(AddHasContext.SET_CONTEXT, (Map)ImmutableMap.of((Object)"context", (Object)((Object)context)));
            }

            @Override
            public FirefoxCommandContext getContext() {
                String context = (String)executeMethod.execute(AddHasContext.GET_CONTEXT, null);
                return FirefoxCommandContext.fromString(context);
            }
        };
    }
}

