/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriverLogLevel;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.ProfilesIni;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AbstractDriverOptions;

public class FirefoxOptions
extends AbstractDriverOptions<FirefoxOptions> {
    public static final String FIREFOX_OPTIONS = "moz:firefoxOptions";
    private Map<String, Object> firefoxOptions = Collections.unmodifiableMap(new TreeMap());
    private boolean legacy;

    public FirefoxOptions() {
        this.setCapability("browserName", "firefox");
        this.setAcceptInsecureCerts(true);
        this.setCapability("moz:debuggerAddress", true);
    }

    public FirefoxOptions(Capabilities source) {
        this();
        source.getCapabilityNames().stream().filter(name -> !FIREFOX_OPTIONS.equals(name)).forEach(name -> {
            Object value = source.getCapability(name);
            if (value != null) {
                this.setCapability((String)name, value);
            }
        });
        if (source instanceof FirefoxOptions) {
            this.mirror((FirefoxOptions)source);
        } else {
            Object rawOptions = source.getCapability(FIREFOX_OPTIONS);
            if (rawOptions != null) {
                Require.stateCondition((boolean)(rawOptions instanceof Map), (String)"Expected options to be a map: %s", (Object[])new Object[]{rawOptions});
                Map sourceOptions = (Map)rawOptions;
                TreeMap<String, Object> options = new TreeMap<String, Object>();
                for (Keys key : Keys.values()) {
                    key.amend(sourceOptions, options);
                }
                this.firefoxOptions = Collections.unmodifiableMap(options);
            }
            if (source.getCapability("marionette") == Boolean.FALSE) {
                this.legacy = true;
            }
        }
    }

    private void mirror(FirefoxOptions that) {
        TreeMap<String, Object> newOptions = new TreeMap<String, Object>(this.firefoxOptions);
        for (Keys key : Keys.values()) {
            Object value = key.mirror(this.firefoxOptions, that.firefoxOptions);
            if (value == null) continue;
            newOptions.put(key.key(), value);
        }
        this.firefoxOptions = Collections.unmodifiableMap(newOptions);
        this.legacy = that.legacy;
    }

    public FirefoxOptions configureFromEnv() {
        String forceMarionette;
        String profileName;
        String binary = System.getProperty("webdriver.firefox.bin");
        if (binary != null) {
            this.setBinary(binary);
        }
        if ((profileName = System.getProperty("webdriver.firefox.profile")) != null) {
            FirefoxProfile profile = new ProfilesIni().getProfile(profileName);
            if (profile == null) {
                throw new WebDriverException(String.format("Firefox profile '%s' named in system property '%s' not found", profileName, "webdriver.firefox.profile"));
            }
            this.setProfile(profile);
        }
        if ((forceMarionette = System.getProperty("webdriver.firefox.marionette")) != null && !Boolean.getBoolean("webdriver.firefox.marionette")) {
            this.setLegacy(true);
        }
        return this;
    }

    @Deprecated
    public FirefoxOptions setLegacy(boolean legacy) {
        this.setCapability("marionette", !legacy);
        return this;
    }

    @Deprecated
    public boolean isLegacy() {
        return this.legacy;
    }

    public FirefoxOptions setBinary(FirefoxBinary binary) {
        Require.nonNull((String)"Binary", (Object)binary);
        this.addArguments(binary.getExtraOptions());
        return this.setFirefoxOption(Keys.BINARY, binary.getPath());
    }

    public FirefoxOptions setBinary(Path path) {
        Require.nonNull((String)"Binary", (Object)path);
        return this.setFirefoxOption(Keys.BINARY, path.toString());
    }

    public FirefoxOptions setBinary(String path) {
        Require.nonNull((String)"Binary", (Object)path);
        return this.setFirefoxOption(Keys.BINARY, path);
    }

    public FirefoxBinary getBinary() {
        return this.getBinaryOrNull().orElseGet(FirefoxBinary::new);
    }

    public Optional<FirefoxBinary> getBinaryOrNull() {
        Object binary = this.firefoxOptions.get(Keys.BINARY.key());
        if (!(binary instanceof String)) {
            return Optional.empty();
        }
        FirefoxBinary toReturn = new FirefoxBinary(new File((String)binary));
        ArrayList rawArgs = this.firefoxOptions.getOrDefault(Keys.ARGS.key(), new ArrayList());
        Require.stateCondition((boolean)(rawArgs instanceof List), (String)"Arguments are not a list: %s", (Object[])new Object[]{rawArgs});
        ((List)rawArgs).stream().filter(Objects::nonNull).map(String::valueOf).forEach(xva$0 -> toReturn.addCommandLineOptions((String)xva$0));
        return Optional.of(toReturn);
    }

    public FirefoxOptions setProfile(FirefoxProfile profile) {
        Require.nonNull((String)"Profile", (Object)profile);
        try {
            return this.setFirefoxOption(Keys.PROFILE, profile.toJson());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public FirefoxProfile getProfile() {
        Object rawProfile = this.firefoxOptions.get(Keys.PROFILE.key());
        if (rawProfile == null) {
            return new FirefoxProfile();
        }
        if (rawProfile instanceof FirefoxProfile) {
            return (FirefoxProfile)rawProfile;
        }
        try {
            return FirefoxProfile.fromJson((String)rawProfile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public FirefoxOptions addArguments(String ... arguments) {
        this.addArguments(Arrays.asList(arguments));
        return this;
    }

    public FirefoxOptions addArguments(List<String> arguments) {
        Require.nonNull((String)"Arguments", arguments);
        ArrayList rawList = this.firefoxOptions.getOrDefault(Keys.ARGS.key(), new ArrayList());
        Require.stateCondition((boolean)(rawList instanceof List), (String)"Arg list of unexpected type: %s", (Object[])new Object[]{rawList});
        ArrayList<String> newArgs = new ArrayList<String>();
        ((List)rawList).stream().map(String::valueOf).forEach(newArgs::add);
        newArgs.addAll(arguments);
        return this.setFirefoxOption(Keys.ARGS, Collections.unmodifiableList(newArgs));
    }

    public FirefoxOptions addPreference(String key, Object value) {
        Require.nonNull((String)"Key", (Object)key);
        Require.nonNull((String)"Value", (Object)value);
        HashMap rawPrefs = this.firefoxOptions.getOrDefault(Keys.PREFS.key(), new HashMap());
        Require.stateCondition((boolean)(rawPrefs instanceof Map), (String)"Prefs are of unexpected type: %s", (Object[])new Object[]{rawPrefs});
        TreeMap<String, Object> newPrefs = new TreeMap<String, Object>();
        Map prefs = rawPrefs;
        newPrefs.putAll(prefs);
        newPrefs.put(key, value);
        return this.setFirefoxOption(Keys.PREFS, Collections.unmodifiableMap(newPrefs));
    }

    public FirefoxOptions setLogLevel(FirefoxDriverLogLevel logLevel) {
        Require.nonNull((String)"Log level", (Object)((Object)logLevel));
        return this.setFirefoxOption(Keys.LOG, logLevel.toJson());
    }

    public FirefoxOptions setHeadless(boolean headless) {
        ArrayList rawArgs = this.firefoxOptions.getOrDefault(Keys.ARGS.key(), new ArrayList());
        Require.stateCondition((boolean)(rawArgs instanceof List), (String)"Arg list of unexpected type: %s", (Object[])new Object[]{rawArgs});
        ArrayList<String> newArgs = new ArrayList<String>();
        ((List)rawArgs).stream().map(String::valueOf).filter(arg -> !"-headless".equals(arg)).forEach(newArgs::add);
        if (headless) {
            newArgs.add("-headless");
        }
        return this.setFirefoxOption(Keys.ARGS, Collections.unmodifiableList(newArgs));
    }

    public void setCapability(String key, Object value) {
        Require.nonNull((String)"Capability name", (Object)key);
        Require.nonNull((String)"Value", (Object)value);
        switch (key) {
            case "firefox_binary": {
                if (value instanceof FirefoxBinary) {
                    this.setBinary((FirefoxBinary)value);
                    break;
                }
                if (value instanceof Path) {
                    this.setBinary((Path)value);
                    break;
                }
                if (value instanceof String) {
                    this.setBinary((String)value);
                    break;
                }
                throw new IllegalArgumentException("Unable to set binary from " + value);
            }
            case "marionette": {
                if (!(value instanceof Boolean)) break;
                this.legacy = (Boolean)value == false;
                break;
            }
            case "firefox_profile": {
                if (value instanceof FirefoxProfile) {
                    this.setProfile((FirefoxProfile)value);
                    break;
                }
                if (value instanceof String) {
                    try {
                        FirefoxProfile profile = FirefoxProfile.fromJson((String)value);
                        this.setProfile(profile);
                        break;
                    }
                    catch (IOException e) {
                        throw new WebDriverException((Throwable)e);
                    }
                }
                throw new WebDriverException("Unexpected value for profile: " + value);
            }
        }
        super.setCapability(key, value);
    }

    private FirefoxOptions setFirefoxOption(Keys key, Object value) {
        TreeMap<String, Object> newOptions = new TreeMap<String, Object>(this.firefoxOptions);
        newOptions.put(key.key(), value);
        this.firefoxOptions = Collections.unmodifiableMap(newOptions);
        return this;
    }

    protected Set<String> getExtraCapabilityNames() {
        TreeSet<String> names = new TreeSet<String>();
        names.add(FIREFOX_OPTIONS);
        if (this.legacy) {
            names.add("marionette");
        }
        return Collections.unmodifiableSet(names);
    }

    protected Object getExtraCapability(String capabilityName) {
        Require.nonNull((String)"Capability name", (Object)capabilityName);
        switch (capabilityName) {
            case "moz:firefoxOptions": {
                return Collections.unmodifiableMap(this.firefoxOptions);
            }
            case "marionette": {
                return !this.legacy;
            }
        }
        return null;
    }

    public FirefoxOptions merge(Capabilities capabilities) {
        Require.nonNull((String)"Capabilities to merge", (Object)capabilities);
        FirefoxOptions newInstance = new FirefoxOptions();
        this.getCapabilityNames().forEach(name -> newInstance.setCapability((String)name, this.getCapability((String)name)));
        capabilities.getCapabilityNames().forEach(name -> newInstance.setCapability((String)name, capabilities.getCapability(name)));
        newInstance.mirror(this);
        if (capabilities instanceof FirefoxOptions) {
            newInstance.mirror((FirefoxOptions)capabilities);
        }
        return newInstance;
    }

    private static enum Keys {
        ARGS("args"){

            @Override
            public void amend(Map<String, Object> sourceOptions, Map<String, Object> toAmend) {
                Object o = sourceOptions.get(this.key());
                if (!(o instanceof List)) {
                    return;
                }
                ArrayList rawArgs = toAmend.getOrDefault(this.key(), new ArrayList());
                List existingArgs = rawArgs;
                List sourceArgs = (List)o;
                ArrayList newArgs = new ArrayList(existingArgs);
                newArgs.addAll(sourceArgs);
                toAmend.put(this.key(), Collections.unmodifiableList(new ArrayList(newArgs)));
            }

            @Override
            public Object mirror(Map<String, Object> first, Map<String, Object> second) {
                ArrayList rawFirst = first.getOrDefault(this.key(), new ArrayList());
                Require.stateCondition((boolean)(rawFirst instanceof List), (String)"Args are of unexpected type: %s", (Object[])new Object[]{rawFirst});
                List firstList = rawFirst;
                ArrayList rawSecond = second.getOrDefault(this.key(), new ArrayList());
                Require.stateCondition((boolean)(rawSecond instanceof List), (String)"Args are of unexpected type: %s", (Object[])new Object[]{rawSecond});
                List secondList = rawSecond;
                ArrayList args = new ArrayList(firstList);
                args.addAll(secondList);
                return args.isEmpty() ? null : args;
            }
        }
        ,
        BINARY("binary"){

            @Override
            public void amend(Map<String, Object> sourceOptions, Map<String, Object> toAmend) {
                Object o = sourceOptions.get(this.key());
                if (o instanceof FirefoxBinary) {
                    FirefoxBinary binary = (FirefoxBinary)o;
                    toAmend.put(this.key(), binary.getFile().toString());
                    ARGS.amend(Collections.singletonMap(ARGS.key(), binary.getExtraOptions()), toAmend);
                } else if (o instanceof String) {
                    toAmend.put(this.key(), o);
                }
            }

            @Override
            public Object mirror(Map<String, Object> first, Map<String, Object> second) {
                Object value = second.get(this.key());
                if (value == null) {
                    value = first.get(this.key());
                }
                if (value == null) {
                    return null;
                }
                Require.stateCondition((boolean)(value instanceof String), (String)"Unexpected type for binary: %s", (Object[])new Object[]{value});
                return value;
            }
        }
        ,
        ENV("env"){

            @Override
            public void amend(Map<String, Object> sourceOptions, Map<String, Object> toAmend) {
                Object o = sourceOptions.get(this.key());
                if (o == null) {
                    return;
                }
                Require.stateCondition((boolean)(o instanceof Map), (String)"Unexpected type for env: %s", (Object[])new Object[]{o});
                Map<String, Object> collected = ((Map)o).entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), Map.Entry::getValue));
                toAmend.put(this.key(), Collections.unmodifiableMap(collected));
            }

            @Override
            public Object mirror(Map<String, Object> first, Map<String, Object> second) {
                TreeMap rawFirst = first.getOrDefault(this.key(), new TreeMap());
                Require.stateCondition((boolean)(rawFirst instanceof Map), (String)"Env vars are of unexpected type: %s", (Object[])new Object[]{rawFirst});
                Map firstPrefs = rawFirst;
                TreeMap rawSecond = second.getOrDefault(this.key(), new TreeMap());
                Require.stateCondition((boolean)(rawSecond instanceof Map), (String)"Env vars are of unexpected type: %s", (Object[])new Object[]{rawSecond});
                Map secondPrefs = rawSecond;
                TreeMap value = new TreeMap(firstPrefs);
                value.putAll(secondPrefs);
                return value.isEmpty() ? null : value;
            }
        }
        ,
        LOG("log"){

            @Override
            public void amend(Map<String, Object> sourceOptions, Map<String, Object> toAmend) {
                Object o = toAmend.get(this.key());
                if (o == null) {
                    return;
                }
                Require.stateCondition((boolean)(o instanceof Map), (String)"Unexpected type for log: %s", (Object[])new Object[]{o});
                toAmend.put(this.key(), o);
            }

            @Override
            public Object mirror(Map<String, Object> first, Map<String, Object> second) {
                Object value = second.get(this.key());
                if (value == null) {
                    value = first.get(this.key());
                }
                if (value == null) {
                    return null;
                }
                Require.stateCondition((boolean)(value instanceof Map), (String)"Log level is of unexpected type: %s", (Object[])new Object[]{value});
                return value;
            }
        }
        ,
        PREFS("prefs"){

            @Override
            public void amend(Map<String, Object> sourceOptions, Map<String, Object> toAmend) {
                Object o = sourceOptions.get(this.key());
                if (o == null) {
                    return;
                }
                Require.stateCondition((boolean)(o instanceof Map), (String)"Unexpected type for preferences: %s", (Object[])new Object[]{o});
                Map<String, Object> collected = ((Map)o).entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), Map.Entry::getValue));
                toAmend.put(this.key(), Collections.unmodifiableMap(collected));
            }

            @Override
            public Object mirror(Map<String, Object> first, Map<String, Object> second) {
                TreeMap rawFirst = first.getOrDefault(this.key(), new TreeMap());
                Require.stateCondition((boolean)(rawFirst instanceof Map), (String)("Prefs are of unexpected type: " + rawFirst), (Object[])new Object[0]);
                Map firstPrefs = rawFirst;
                TreeMap rawSecond = second.getOrDefault(this.key(), new TreeMap());
                Require.stateCondition((boolean)(rawSecond instanceof Map), (String)("Prefs are of unexpected type: " + rawSecond), (Object[])new Object[0]);
                Map secondPrefs = rawSecond;
                TreeMap value = new TreeMap(firstPrefs);
                value.putAll(secondPrefs);
                return value.isEmpty() ? null : value;
            }
        }
        ,
        PROFILE("profile"){

            @Override
            public void amend(Map<String, Object> sourceOptions, Map<String, Object> toAmend) {
                Object o = sourceOptions.get(this.key());
                if (o == null) {
                    return;
                }
                if (o instanceof FirefoxProfile) {
                    toAmend.put(this.key(), o);
                    return;
                }
                Require.stateCondition((boolean)(o instanceof String), (String)"Unexpected type for profile: %s", (Object[])new Object[]{o});
                toAmend.put(this.key(), o);
            }

            @Override
            public Object mirror(Map<String, Object> first, Map<String, Object> second) {
                Object value = second.get(this.key());
                if (value == null) {
                    value = first.get(this.key());
                }
                if (value == null) {
                    return null;
                }
                Require.stateCondition((boolean)(value instanceof String), (String)"Profile is of unexpected type: %s", (Object[])new Object[]{value});
                return value;
            }
        };

        private final String key;

        private Keys(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        public abstract void amend(Map<String, Object> var1, Map<String, Object> var2);

        public abstract Object mirror(Map<String, Object> var1, Map<String, Object> var2);
    }
}

