/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.Extension;
import org.openqa.selenium.firefox.FileExtension;
import org.openqa.selenium.io.FileHandler;

public class ClasspathExtension
implements Extension {
    private final Class<?> loadResourcesUsing;
    private final String loadFrom;

    public ClasspathExtension(Class<?> loadResourcesUsing, String loadFrom) {
        this.loadResourcesUsing = loadResourcesUsing;
        this.loadFrom = loadFrom;
    }

    @Override
    public void writeTo(File extensionsDir) throws IOException {
        if (!FileHandler.isZipped((String)this.loadFrom)) {
            throw new WebDriverException("Will only install zipped extensions for now");
        }
        File holdingPen = new File(extensionsDir, "webdriver-staging");
        FileHandler.createDir((File)holdingPen);
        File extractedXpi = new File(holdingPen, this.loadFrom);
        File parentDir = extractedXpi.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        URL resourceUrl = Resources.getResource(this.loadResourcesUsing, (String)this.loadFrom);
        try (FileOutputStream stream = new FileOutputStream(extractedXpi);){
            Resources.copy((URL)resourceUrl, (OutputStream)stream);
        }
        new FileExtension(extractedXpi).writeTo(extensionsDir);
    }
}

