/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chromium;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chromium.ChromiumDevToolsLocator;
import org.openqa.selenium.devtools.Connection;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.html5.LocationContext;
import org.openqa.selenium.html5.SessionStorage;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.interactions.HasTouchScreen;
import org.openqa.selenium.interactions.TouchScreen;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.mobile.NetworkConnection;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteTouchScreen;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.html5.RemoteLocationContext;
import org.openqa.selenium.remote.html5.RemoteWebStorage;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.mobile.RemoteNetworkConnection;

public class ChromiumDriver
extends RemoteWebDriver
implements HasDevTools,
HasTouchScreen,
LocationContext,
NetworkConnection,
WebStorage {
    private final RemoteLocationContext locationContext = new RemoteLocationContext(this.getExecuteMethod());
    private final RemoteWebStorage webStorage = new RemoteWebStorage(this.getExecuteMethod());
    private final TouchScreen touchScreen = new RemoteTouchScreen(this.getExecuteMethod());
    private final RemoteNetworkConnection networkConnection = new RemoteNetworkConnection(this.getExecuteMethod());
    private final Optional<Connection> connection;
    private final Optional<DevTools> devTools;

    protected ChromiumDriver(CommandExecutor commandExecutor, Capabilities capabilities, String capabilityKey) {
        super(commandExecutor, capabilities);
        HttpClient.Factory factory = HttpClient.Factory.createDefault();
        this.connection = ChromiumDevToolsLocator.getChromeConnector(factory, this.getCapabilities(), capabilityKey);
        this.devTools = this.connection.map(DevTools::new);
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    public LocalStorage getLocalStorage() {
        return this.webStorage.getLocalStorage();
    }

    public SessionStorage getSessionStorage() {
        return this.webStorage.getSessionStorage();
    }

    public Location location() {
        return this.locationContext.location();
    }

    public void setLocation(Location location) {
        this.locationContext.setLocation(location);
    }

    public TouchScreen getTouch() {
        return this.touchScreen;
    }

    public NetworkConnection.ConnectionType getNetworkConnection() {
        return this.networkConnection.getNetworkConnection();
    }

    public NetworkConnection.ConnectionType setNetworkConnection(NetworkConnection.ConnectionType type) {
        return this.networkConnection.setNetworkConnection(type);
    }

    public void launchApp(String id) {
        this.execute("launchApp", (Map)ImmutableMap.of((Object)"id", (Object)id));
    }

    public Map<String, Object> executeCdpCommand(String commandName, Map<String, Object> parameters) {
        Require.nonNull((String)"Command name", (Object)commandName);
        Require.nonNull((String)"Parameters", parameters);
        Map toReturn = (Map)this.getExecuteMethod().execute("executeCdpCommand", (Map)ImmutableMap.of((Object)"cmd", (Object)commandName, (Object)"params", parameters));
        return ImmutableMap.copyOf((Map)toReturn);
    }

    public DevTools getDevTools() {
        return this.devTools.orElseThrow(() -> new WebDriverException("Unable to create DevTools connection"));
    }

    public String getCastSinks() {
        Object response = this.getExecuteMethod().execute("getCastSinks", null);
        return response.toString();
    }

    public String getCastIssueMessage() {
        Object response = this.getExecuteMethod().execute("getCastIssueMessage", null);
        return response.toString();
    }

    public void selectCastSink(String deviceName) {
        Object response = this.getExecuteMethod().execute("selectCastSink", (Map)ImmutableMap.of((Object)"sinkName", (Object)deviceName));
    }

    public void startTabMirroring(String deviceName) {
        Object response = this.getExecuteMethod().execute("startCastTabMirroring", (Map)ImmutableMap.of((Object)"sinkName", (Object)deviceName));
    }

    public void stopCasting(String deviceName) {
        Object response = this.getExecuteMethod().execute("stopCasting", (Map)ImmutableMap.of((Object)"sinkName", (Object)deviceName));
    }

    public void setPermission(String name, String value) {
        Object response = this.getExecuteMethod().execute("setPermission", (Map)ImmutableMap.of((Object)"descriptor", (Object)ImmutableMap.of((Object)"name", (Object)name), (Object)"state", (Object)value));
    }

    public void quit() {
        this.connection.ifPresent(Connection::close);
        super.quit();
    }
}

