/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.virtualauthenticator;

import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.internal.Require;

public class Credential {
    private final byte[] id;
    private final boolean isResidentCredential;
    private final String rpId;
    private final PKCS8EncodedKeySpec privateKey;
    private final byte[] userHandle;
    private final int signCount;

    public static Credential createNonResidentCredential(byte[] id, String rpId, PKCS8EncodedKeySpec privateKey, int signCount) {
        return new Credential(id, false, Require.nonNull("rpId", rpId), privateKey, null, signCount);
    }

    public static Credential createResidentCredential(byte[] id, String rpId, PKCS8EncodedKeySpec privateKey, byte[] userHandle, int signCount) {
        return new Credential(id, true, Require.nonNull("rpId", rpId), privateKey, Require.nonNull("User handle", userHandle), signCount);
    }

    public static Credential fromMap(Map<String, Object> map) {
        Base64.Decoder decoder = Base64.getUrlDecoder();
        return new Credential(decoder.decode((String)map.get("credentialId")), (Boolean)map.get("isResidentCredential"), (String)map.get("rpId"), new PKCS8EncodedKeySpec(decoder.decode((String)map.get("privateKey"))), map.get("userHandle") == null ? null : decoder.decode((String)map.get("userHandle")), ((Long)map.get("signCount")).intValue());
    }

    private Credential(byte[] id, boolean isResidentCredential, String rpId, PKCS8EncodedKeySpec privateKey, byte[] userHandle, int signCount) {
        this.id = Require.nonNull("Id", id);
        this.isResidentCredential = isResidentCredential;
        this.rpId = rpId;
        this.privateKey = Require.nonNull("Private key", privateKey);
        this.userHandle = userHandle;
        this.signCount = signCount;
    }

    public byte[] getId() {
        return Arrays.copyOf(this.id, this.id.length);
    }

    public boolean isResidentCredential() {
        return this.isResidentCredential;
    }

    public String getRpId() {
        return this.rpId;
    }

    public PKCS8EncodedKeySpec getPrivateKey() {
        return this.privateKey;
    }

    public byte[] getUserHandle() {
        return this.userHandle == null ? null : Arrays.copyOf(this.userHandle, this.userHandle.length);
    }

    public int getSignCount() {
        return this.signCount;
    }

    public Map<String, Object> toMap() {
        Base64.Encoder encoder = Base64.getUrlEncoder();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("credentialId", encoder.encodeToString(this.id));
        map.put("isResidentCredential", this.isResidentCredential);
        map.put("rpId", this.rpId);
        map.put("privateKey", encoder.encodeToString(this.privateKey.getEncoded()));
        map.put("signCount", this.signCount);
        if (this.userHandle != null) {
            map.put("userHandle", encoder.encodeToString(this.userHandle));
        }
        return Collections.unmodifiableMap(map);
    }
}

