/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.ScriptKey;

class UnpinnedScriptKey
extends ScriptKey {
    private static final WeakHashMap<JavascriptExecutor, Set<UnpinnedScriptKey>> pinnedScripts = new WeakHashMap();
    private final String script;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static UnpinnedScriptKey pin(JavascriptExecutor executor, String script) {
        UnpinnedScriptKey toReturn = new UnpinnedScriptKey(script);
        WeakHashMap<JavascriptExecutor, Set<UnpinnedScriptKey>> weakHashMap = pinnedScripts;
        synchronized (weakHashMap) {
            pinnedScripts.computeIfAbsent(executor, ignored -> new HashSet()).add(toReturn);
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unpin(JavascriptExecutor executor, UnpinnedScriptKey key) {
        WeakHashMap<JavascriptExecutor, Set<UnpinnedScriptKey>> weakHashMap = pinnedScripts;
        synchronized (weakHashMap) {
            ((Set)pinnedScripts.getOrDefault(executor, new HashSet())).remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<UnpinnedScriptKey> getPinnedScripts(JavascriptExecutor executor) {
        Set toReturn;
        WeakHashMap<JavascriptExecutor, Set<UnpinnedScriptKey>> weakHashMap = pinnedScripts;
        synchronized (weakHashMap) {
            toReturn = pinnedScripts.getOrDefault(executor, new HashSet());
        }
        return Collections.unmodifiableSet(toReturn);
    }

    private UnpinnedScriptKey(String script) {
        super(script);
        this.script = script;
    }

    String getScript() {
        return this.script;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UnpinnedScriptKey that = (UnpinnedScriptKey)o;
        return Objects.equals(this.script, that.script);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.script);
    }
}

