/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.HttpContext;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.ComponentEvent;
import org.openqa.jetty.util.ComponentListener;
import org.openqa.jetty.util.EventProvider;
import org.openqa.jetty.util.LazyList;
import org.openqa.jetty.util.LifeCycle;
import org.openqa.jetty.util.LifeCycleEvent;
import org.openqa.jetty.util.LifeCycleListener;

public abstract class Container
implements LifeCycle,
EventProvider,
Serializable {
    private static Log log = LogFactory.getLog(Container.class);
    private Object _eventListeners;
    private Object _components;
    private transient boolean _started;
    private transient boolean _starting;
    private transient boolean _stopping;

    /*
     * Unable to fully structure code
     */
    @Override
    public final synchronized void start() throws Exception {
        block16: {
            if (this._started || this._starting) {
                return;
            }
            this._starting = true;
            if (Container.log.isDebugEnabled()) {
                Container.log.debug((Object)("Starting " + this));
            }
            event = new LifeCycleEvent(this);
            i = 0;
            while (i < LazyList.size(this._eventListeners)) {
                listener = (EventListener)LazyList.get(this._eventListeners, i);
                if (listener instanceof LifeCycleListener) {
                    ((LifeCycleListener)listener).lifeCycleStarting(event);
                }
                ++i;
            }
            try {
                try {
                    this.doStart();
                    this._started = true;
                    Container.log.info((Object)("Started " + this));
                    i = 0;
                    while (i < LazyList.size(this._eventListeners)) {
                        listener = (EventListener)LazyList.get(this._eventListeners, i);
                        if (listener instanceof LifeCycleListener) {
                            ((LifeCycleListener)listener).lifeCycleStarted(event);
                        }
                        ++i;
                    }
                    break block16;
                }
                catch (Throwable e) {
                    new LifeCycleEvent(this, e);
                    i = 0;
                    ** while (i < LazyList.size((Object)this._eventListeners))
                }
lbl-1000:
                // 1 sources

                {
                    listener = (EventListener)LazyList.get(this._eventListeners, i);
                    if (listener instanceof LifeCycleListener) {
                        ((LifeCycleListener)listener).lifeCycleFailure(event);
                    }
                    ++i;
                    continue;
                }
lbl36:
                // 1 sources

                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                Container.log.warn((Object)"EXCEPTION ", e);
            }
            finally {
                this._starting = false;
            }
        }
    }

    protected abstract void doStart() throws Exception;

    @Override
    public synchronized boolean isStarted() {
        return this._started;
    }

    protected synchronized boolean isStarting() {
        return this._starting;
    }

    protected synchronized boolean isStopping() {
        return this._stopping;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final synchronized void stop() throws InterruptedException {
        block16: {
            if (!this._started || this._stopping) {
                return;
            }
            this._stopping = true;
            if (Container.log.isDebugEnabled()) {
                Container.log.debug((Object)("Stopping " + this));
            }
            event = new LifeCycleEvent(this);
            i = 0;
            while (i < LazyList.size(this._eventListeners)) {
                listener = (EventListener)LazyList.get(this._eventListeners, i);
                if (listener instanceof LifeCycleListener) {
                    ((LifeCycleListener)listener).lifeCycleStopping(event);
                }
                ++i;
            }
            try {
                try {
                    this.doStop();
                    this._started = false;
                    Container.log.info((Object)("Stopped " + this));
                    i = 0;
                    while (i < LazyList.size(this._eventListeners)) {
                        listener = (EventListener)LazyList.get(this._eventListeners, i);
                        if (listener instanceof LifeCycleListener) {
                            ((LifeCycleListener)listener).lifeCycleStopped(event);
                        }
                        ++i;
                    }
                    break block16;
                }
                catch (Throwable e) {
                    event = new LifeCycleEvent(this, e);
                    i = 0;
                    ** while (i < LazyList.size((Object)this._eventListeners))
                }
lbl-1000:
                // 1 sources

                {
                    listener = (EventListener)LazyList.get(this._eventListeners, i);
                    if (listener instanceof LifeCycleListener) {
                        ((LifeCycleListener)listener).lifeCycleFailure(event);
                    }
                    ++i;
                    continue;
                }
lbl36:
                // 1 sources

                if (e instanceof InterruptedException) {
                    throw (InterruptedException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                Container.log.warn((Object)"EXCEPTION ", e);
            }
            finally {
                this._stopping = false;
            }
        }
    }

    protected abstract void doStop() throws Exception;

    protected void addComponent(Object o) {
        if (!LazyList.contains(this._components, o)) {
            this._components = LazyList.add(this._components, o);
            if (log.isDebugEnabled()) {
                log.debug((Object)("add component: " + o));
            }
            ComponentEvent event = new ComponentEvent(this, o);
            int i = 0;
            while (i < LazyList.size(this._eventListeners)) {
                EventListener listener = (EventListener)LazyList.get(this._eventListeners, i);
                if (listener instanceof ComponentListener) {
                    ((ComponentListener)listener).addComponent(event);
                }
                ++i;
            }
        }
    }

    protected void removeComponent(Object o) {
        if (LazyList.contains(this._components, o)) {
            this._components = LazyList.remove(this._components, o);
            if (log.isDebugEnabled()) {
                log.debug((Object)("remove component: " + o));
            }
            ComponentEvent event = new ComponentEvent(this, o);
            int i = 0;
            while (i < LazyList.size(this._eventListeners)) {
                EventListener listener = (EventListener)LazyList.get(this._eventListeners, i);
                if (listener instanceof ComponentListener) {
                    ((ComponentListener)listener).removeComponent(event);
                }
                ++i;
            }
        }
    }

    @Override
    public void addEventListener(EventListener listener) throws IllegalArgumentException {
        if (this._eventListeners == null) {
            this._eventListeners = new ArrayList();
        }
        if (listener instanceof ComponentListener || listener instanceof LifeCycleListener) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("addEventListener: " + listener));
            }
            this._eventListeners = LazyList.add(this._eventListeners, listener);
        }
    }

    @Override
    public void removeEventListener(EventListener listener) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeEventListener: " + listener));
        }
        this._eventListeners = LazyList.remove(this._eventListeners, listener);
    }

    public void destroy() {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (this._components != null && this._eventListeners != null) {
            int c = 0;
            while (c < LazyList.size(this._components)) {
                Object o = LazyList.get(this._components, c);
                if (o instanceof HttpContext) {
                    ((HttpContext)o).destroy();
                }
                ComponentEvent event = new ComponentEvent(this, o);
                int i = 0;
                while (i < LazyList.size(this._eventListeners)) {
                    EventListener listener = (EventListener)LazyList.get(this._eventListeners, i);
                    if (listener instanceof ComponentListener) {
                        ((ComponentListener)listener).removeComponent(event);
                    }
                    ++i;
                }
                ++c;
            }
        }
        this._components = null;
        this._eventListeners = null;
    }

    public Collection getComponents() {
        return LazyList.getList(this._eventListeners, false);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int c = 0;
        while (c < LazyList.size(this._components)) {
            Object o = LazyList.get(this._components, c);
            ComponentEvent event = new ComponentEvent(this, o);
            int i = 0;
            while (i < LazyList.size(this._eventListeners)) {
                EventListener listener = (EventListener)LazyList.get(this._eventListeners, i);
                if (listener instanceof ComponentListener) {
                    ((ComponentListener)listener).addComponent(event);
                }
                ++i;
            }
            ++c;
        }
    }
}

