/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit.options;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.htmlunit.ProxyConfig;

public class ProxyConfigBean
implements Serializable {
    private String host_;
    private int port_;
    private String scheme_;
    private boolean socksProxy_;
    private List<String> bypassHosts_;
    private String autoConfigUrl_;

    public String getHost() {
        return this.host_;
    }

    public void setHost(String host) {
        this.host_ = host;
    }

    public int getPort() {
        return this.port_;
    }

    public void setPort(int port) {
        this.port_ = port;
    }

    public String getScheme() {
        return this.scheme_;
    }

    public void setScheme(String scheme) {
        this.scheme_ = scheme;
    }

    public boolean isSocksProxy() {
        return this.socksProxy_;
    }

    public void setSocksProxy(boolean socksProxy) {
        this.socksProxy_ = socksProxy;
    }

    public List<String> getBypassHosts() {
        return this.bypassHosts_;
    }

    public String getBypassHosts(int index) {
        return this.bypassHosts_.get(index);
    }

    public void setBypassHosts(List<String> bypassHosts) {
        this.bypassHosts_ = bypassHosts;
    }

    public void setBypassHosts(int index, String bypassHost) {
        this.bypassHosts_.set(index, bypassHost);
    }

    public String getAutoConfigUrl() {
        return this.autoConfigUrl_;
    }

    public void setAutoConfigUrl(String autoConfigUrl) {
        this.autoConfigUrl_ = autoConfigUrl;
    }

    public static Map<String, Object> encodeProxyConfig(ProxyConfig value) {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("host", value.getProxyHost());
        configMap.put("port", value.getProxyPort());
        configMap.put("scheme", value.getProxyScheme());
        configMap.put("bypassHosts", ProxyConfigBean.getBypassHosts(value));
        configMap.put("autoConfigUrl", value.getProxyAutoConfigUrl());
        return configMap;
    }

    public ProxyConfig build() {
        ProxyConfig value = new ProxyConfig(this.host_, this.port_, this.scheme_, this.socksProxy_);
        this.bypassHosts_.forEach(arg_0 -> ((ProxyConfig)value).addHostsToProxyBypass(arg_0));
        value.setProxyAutoConfigUrl(this.autoConfigUrl_);
        return value;
    }

    static List<String> getBypassHosts(ProxyConfig value) {
        try {
            Field proxyBypassHostsField = ProxyConfig.class.getDeclaredField("proxyBypassHosts_");
            proxyBypassHostsField.setAccessible(true);
            Map proxyBypassHosts = (Map)proxyBypassHostsField.get(value);
            return new ArrayList<String>(proxyBypassHosts.keySet());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return null;
        }
    }
}

