/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import java.io.IOException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.htmlunit.HtmlUnitKeyboardMapping;
import org.openqa.selenium.htmlunit.HtmlUnitWebElement;
import org.openqa.selenium.htmlunit.InputKeysContainer;
import org.openqa.selenium.htmlunit.KeyboardModifiersState;
import org.openqa.selenium.interactions.Keyboard;

public class HtmlUnitKeyboard
implements Keyboard {
    private KeyboardModifiersState modifiersState = new KeyboardModifiersState();
    private final HtmlUnitDriver parent;
    private HtmlElement lastElement;

    HtmlUnitKeyboard(HtmlUnitDriver parent) {
        this.parent = parent;
    }

    private HtmlUnitWebElement getElementToSend(WebElement toElement) {
        WebElement sendToElement = toElement;
        if (sendToElement == null) {
            sendToElement = this.parent.switchTo().activeElement();
        }
        return (HtmlUnitWebElement)sendToElement;
    }

    public void sendKeys(CharSequence ... keysToSend) {
        WebElement toElement = this.parent.switchTo().activeElement();
        HtmlUnitWebElement htmlElem = this.getElementToSend(toElement);
        htmlElem.sendKeys(false, keysToSend);
    }

    public void sendKeys(HtmlElement element, InputKeysContainer keysToSend, boolean releaseAllAtEnd) {
        keysToSend.setCapitalization(this.modifiersState.isShiftPressed());
        String keysSequence = keysToSend.toString();
        if (element instanceof HtmlFileInput) {
            HtmlFileInput fileInput = (HtmlFileInput)element;
            fileInput.setValueAttribute(keysSequence);
            return;
        }
        try {
            com.gargoylesoftware.htmlunit.html.Keyboard keyboard = this.asHtmlUnitKeyboard(this.lastElement != element, keysSequence, true);
            if (releaseAllAtEnd) {
                if (this.isShiftPressed()) {
                    this.addToKeyboard(keyboard, Keys.SHIFT.charAt(0), false);
                }
                if (this.isAltPressed()) {
                    this.addToKeyboard(keyboard, Keys.ALT.charAt(0), false);
                }
                if (this.isCtrlPressed()) {
                    this.addToKeyboard(keyboard, Keys.CONTROL.charAt(0), false);
                }
            }
            element.type(keyboard);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        this.lastElement = element;
    }

    private com.gargoylesoftware.htmlunit.html.Keyboard asHtmlUnitKeyboard(boolean startAtEnd, CharSequence keysSequence, boolean isPress) {
        com.gargoylesoftware.htmlunit.html.Keyboard keyboard = new com.gargoylesoftware.htmlunit.html.Keyboard(startAtEnd);
        for (int i = 0; i < keysSequence.length(); ++i) {
            char ch = keysSequence.charAt(i);
            this.addToKeyboard(keyboard, ch, isPress);
        }
        return keyboard;
    }

    private void addToKeyboard(com.gargoylesoftware.htmlunit.html.Keyboard keyboard, char ch, boolean isPress) {
        if (HtmlUnitKeyboardMapping.isSpecialKey(ch)) {
            int keyCode = HtmlUnitKeyboardMapping.getKeysMapping(ch);
            if (isPress) {
                keyboard.press(keyCode);
                this.modifiersState.storeKeyDown(ch);
            } else {
                keyboard.release(keyCode);
                this.modifiersState.storeKeyUp(ch);
            }
        } else {
            keyboard.type(ch);
        }
    }

    public void pressKey(CharSequence keyToPress) {
        WebElement toElement = this.parent.switchTo().activeElement();
        HtmlUnitWebElement htmlElement = this.getElementToSend(toElement);
        HtmlElement element = (HtmlElement)htmlElement.element;
        try {
            element.type(this.asHtmlUnitKeyboard(this.lastElement != element, keyToPress, true));
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        for (int i = 0; i < keyToPress.length(); ++i) {
            char ch = keyToPress.charAt(i);
            this.modifiersState.storeKeyDown(ch);
        }
    }

    public void releaseKey(CharSequence keyToRelease) {
        WebElement toElement = this.parent.switchTo().activeElement();
        HtmlUnitWebElement htmlElement = this.getElementToSend(toElement);
        HtmlElement element = (HtmlElement)htmlElement.element;
        try {
            element.type(this.asHtmlUnitKeyboard(this.lastElement != element, keyToRelease, false));
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        for (int i = 0; i < keyToRelease.length(); ++i) {
            char ch = keyToRelease.charAt(i);
            this.modifiersState.storeKeyUp(ch);
        }
    }

    public boolean isShiftPressed() {
        return this.modifiersState.isShiftPressed();
    }

    public boolean isCtrlPressed() {
        return this.modifiersState.isCtrlPressed();
    }

    public boolean isAltPressed() {
        return this.modifiersState.isAltPressed();
    }
}

