/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.projection.rules;

import org.scribble.context.ModuleContext;
import org.scribble.logging.IssueLogger;
import org.scribble.model.Argument;
import org.scribble.model.ModelObject;
import org.scribble.model.ProtocolDecl;
import org.scribble.model.RoleDecl;
import org.scribble.model.RoleInstantiation;
import org.scribble.model.global.GProtocolInstance;
import org.scribble.model.local.LProtocolDecl;
import org.scribble.model.local.LProtocolInstance;
import org.scribble.projection.rules.AbstractProtocolDeclProjectionRule;
import org.scribble.projection.rules.ProjectionRule;

public class GProtocolInstanceProjectionRule
extends AbstractProtocolDeclProjectionRule
implements ProjectionRule {
    @Override
    public Object project(ModuleContext context, ModelObject mobj, RoleDecl role, IssueLogger logger) {
        LProtocolInstance projected = new LProtocolInstance();
        GProtocolInstance source = (GProtocolInstance)mobj;
        projected.derivedFrom((ModelObject)source);
        this.projectProtocolDecl(context, (ProtocolDecl)source, (LProtocolDecl)projected, role, logger);
        String protocolName = source.getMemberName();
        if (protocolName.indexOf(46) != -1) {
            ModelObject mo;
            int index;
            RoleInstantiation targetri = source.getRoleInstantiation(role);
            if (targetri == null) {
                logger.error("Could not find role '" + role + "'", mobj);
                return null;
            }
            String otherRole = targetri.getAlias();
            if (otherRole == null && (index = source.getRoleInstantiations().indexOf(targetri)) != -1 && (mo = context.getMember(protocolName)) instanceof ProtocolDecl) {
                ProtocolDecl pd = (ProtocolDecl)mo;
                if (pd.getRoleDeclarations().size() <= index) {
                    logger.error("Could not determine target role for '" + role + "'", mobj);
                } else {
                    otherRole = ((RoleDecl)pd.getRoleDeclarations().get(index)).getName();
                }
            }
            if (otherRole != null) {
                index = protocolName.lastIndexOf(46);
                protocolName = protocolName.substring(0, index) + "_" + otherRole + protocolName.substring(index);
            }
        }
        projected.setMemberName(protocolName);
        for (Argument arg : source.getArguments()) {
            projected.getArguments().add(new Argument(arg));
        }
        for (RoleInstantiation ri : source.getRoleInstantiations()) {
            projected.getRoleInstantiations().add(new RoleInstantiation(ri));
        }
        return projected;
    }
}

