/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;
import org.codehaus.jackson.map.ObjectMapper;
import org.scribble.context.DefaultModuleContext;
import org.scribble.context.ModuleContext;
import org.scribble.context.ModuleLoader;
import org.scribble.logging.ConsoleIssueLogger;
import org.scribble.logging.IssueLogger;
import org.scribble.model.Module;
import org.scribble.parser.ProtocolModuleLoader;
import org.scribble.parser.ProtocolParser;
import org.scribble.projection.ProtocolProjector;
import org.scribble.resources.DirectoryResourceLocator;
import org.scribble.resources.Resource;
import org.scribble.resources.ResourceLocator;
import org.scribble.trace.model.Simulation;
import org.scribble.trace.model.Step;
import org.scribble.trace.model.Trace;
import org.scribble.trace.simulation.DefaultSimulatorContext;
import org.scribble.trace.simulation.SimulationListener;
import org.scribble.trace.simulation.Simulator;
import org.scribble.trace.simulation.SimulatorContext;
import org.scribble.validation.ProtocolValidator;

public class CommandLine {
    private static final String MODULE_PATH = "MODULE_PATH";
    private static final ProtocolParser PARSER = new ProtocolParser();
    private static final ProtocolValidator VALIDATOR = new ProtocolValidator();
    private static final ProtocolProjector PROJECTOR = new ProtocolProjector();
    private static final IssueLogger LOGGER = new ConsoleIssueLogger();
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private DirectoryResourceLocator _locator;
    private ProtocolModuleLoader _loader;

    public static void main(String[] args) {
        CommandLine cli = new CommandLine();
        if (!cli.execute(args)) {
            System.exit(1);
        }
    }

    public boolean execute(String[] args) {
        boolean f_usageError = false;
        boolean f_error = false;
        if (args.length > 0) {
            int i;
            for (i = 0; !f_usageError && i < args.length - 1; ++i) {
                if (!args[i].equals("-path")) continue;
                if (i >= args.length - 2) {
                    System.err.println("ERROR: No path value has been defined\r\n");
                    f_usageError = true;
                    break;
                }
                boolean bl = f_usageError = !CommandLine.validatePaths(args[++i]);
                if (!f_usageError) {
                    this.initLoader(args[i]);
                    break;
                }
                System.err.println("ERROR: Module path '" + args[i] + "' is not valid\r\n");
                f_usageError = true;
                break;
            }
            if (!f_usageError && this._locator == null) {
                if (!System.getenv().containsKey(MODULE_PATH)) {
                    System.err.println("ERROR: MODULE_PATH has not been defined\r\n");
                    f_usageError = true;
                } else if (!CommandLine.validatePaths(System.getenv().get(MODULE_PATH))) {
                    System.err.println("ERROR: Module path '" + System.getenv().get(MODULE_PATH) + "' is not valid\r\n");
                    f_usageError = true;
                } else {
                    this.initLoader(System.getenv().get(MODULE_PATH));
                }
            }
            for (i = 0; !f_usageError && i < args.length - 1; ++i) {
                Resource resource;
                if (args[i].equals("-path")) {
                    ++i;
                    continue;
                }
                if (args[i].equals("-project")) {
                    if (i + 1 >= args.length) {
                        System.err.println("ERROR: No global module has been defined\r\n");
                        f_usageError = true;
                        continue;
                    }
                    if (!CommandLine.validateModuleName(args[++i])) {
                        System.err.println("ERROR: Module name '" + args[i] + "' is not valid\r\n");
                        f_usageError = true;
                        continue;
                    }
                    resource = this.getResource(args[i]);
                    if (resource != null) {
                        Module module = this.loadModule(resource);
                        if (module == null) continue;
                        this.project(module, resource);
                        continue;
                    }
                    System.err.println("ERROR: Module name '" + args[i] + "' could not be located\r\n");
                    continue;
                }
                if (args[i].equals("-validate")) {
                    if (i + 1 >= args.length) {
                        System.err.println("ERROR: No module has been defined\r\n");
                        f_usageError = true;
                        continue;
                    }
                    if (!CommandLine.validateModuleName(args[++i])) {
                        System.err.println("ERROR: Module name '" + args[i] + "' is not valid\r\n");
                        f_usageError = true;
                        continue;
                    }
                    resource = this.getResource(args[i]);
                    if (resource != null) {
                        this.loadModule(resource);
                        continue;
                    }
                    System.err.println("ERROR: Module name '" + args[i] + "' could not be located\r\n");
                    continue;
                }
                if (args[i].equals("-simulate")) {
                    File location;
                    if (i + 1 >= args.length) {
                        System.err.println("ERROR: No trace file has been defined\r\n");
                        f_usageError = true;
                        continue;
                    }
                    if (!CommandLine.validateTraceLocation(location = new File(args[++i]))) {
                        System.err.println("ERROR: No trace files could be found at location '" + args[i] + "'\r\n");
                        f_usageError = true;
                        continue;
                    }
                    if (this.simulate(location)) continue;
                    System.err.println("\r\nERROR: Simulation failed\r\n");
                    f_error = true;
                    continue;
                }
                System.err.println("ERROR: Unknown option '" + args[i] + "'\r\n");
                f_usageError = true;
            }
        } else {
            f_usageError = true;
        }
        if (f_usageError) {
            System.err.println("Usage: scribble [-path <module-path>] [ -project <module> ] [ -simulate <trace file/dir> ]");
            System.err.println("Options:");
            System.err.println("\t-path\t\tList of root directories separated by ':'");
            System.err.println("\t-project\tProject global protocols to local");
            System.err.println("\t-simulate\tSimulate the supplied trace file or files within a directory");
        }
        return !f_usageError && !f_error;
    }

    protected void initLoader(String paths) {
        this._locator = new DirectoryResourceLocator(paths);
        this._loader = new ProtocolModuleLoader(PARSER, (ResourceLocator)this._locator, LOGGER);
    }

    protected Resource getResource(String moduleName) {
        String relativePath = moduleName.replace('.', File.separatorChar) + ".scr";
        return this._locator.getResource(relativePath);
    }

    protected Module loadModule(Resource resource) {
        Module module = null;
        try {
            module = PARSER.parse(resource, (ModuleLoader)this._loader, LOGGER);
            if (module != null) {
                DefaultModuleContext context = new DefaultModuleContext(resource, module, (ModuleLoader)this._loader);
                VALIDATOR.validate((ModuleContext)context, module, LOGGER);
            }
        }
        catch (IOException e) {
            System.err.println("ERROR: Failed to parse '" + resource + "': " + e + "\r\n");
        }
        return module;
    }

    protected static boolean validateModuleName(String module) {
        for (String part : module.split(".")) {
            for (int i = 0; i < part.length(); ++i) {
                if (Character.isLetterOrDigit(part.charAt(i)) || part.charAt(i) == '_') continue;
                return false;
            }
        }
        return true;
    }

    protected static boolean validatePaths(String paths) {
        for (String path : paths.split(":")) {
            File f = new File(path);
            if (f.isDirectory()) continue;
            return false;
        }
        return true;
    }

    protected void project(Module module, Resource resource) {
        String resourceRoot = this._locator.getResourceRoot(resource);
        if (resourceRoot == null) {
            System.err.println("Unable to find root location for resource");
            return;
        }
        DefaultModuleContext context = new DefaultModuleContext(resource, module, (ModuleLoader)this._loader);
        Set modules = PROJECTOR.project((ModuleContext)context, module, LOGGER);
        for (Module m : modules) {
            String name = m.getName().replace('.', File.separatorChar);
            String path = resourceRoot + File.separatorChar + name + "@" + m.getLocatedRole().getName() + ".scr";
            try {
                FileOutputStream fos = new FileOutputStream(path);
                fos.write(m.toString().getBytes());
                fos.flush();
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static boolean validateTraceLocation(File location) {
        boolean ret = false;
        if (location.exists()) {
            if (location.isFile()) {
                ret = location.getName().endsWith(".trace");
            } else if (location.isDirectory()) {
                for (File child : location.listFiles()) {
                    if (!CommandLine.validateTraceLocation(child)) continue;
                    ret = true;
                    break;
                }
            }
        }
        return ret;
    }

    protected boolean simulate(File location) {
        boolean ret = true;
        if (location.exists()) {
            if (location.isFile()) {
                if (location.getName().endsWith(".trace")) {
                    System.out.println("\r\nSimulate: " + location.getPath());
                    try {
                        FileInputStream is = new FileInputStream(location);
                        Trace trace = (Trace)MAPPER.readValue((InputStream)is, Trace.class);
                        ((InputStream)is).close();
                        DefaultSimulatorContext context = new DefaultSimulatorContext((ResourceLocator)this._locator);
                        Simulator simulator = new Simulator();
                        final ArrayList failed = new ArrayList();
                        SimulationListener l = new SimulationListener(){

                            public void start(Trace trace, Simulation simulation) {
                            }

                            public void start(Trace trace, Simulation simulation, Step step) {
                            }

                            public void successful(Trace trace, Simulation simulation, Step step) {
                                System.out.println("\tSUCCESSFUL: " + step);
                            }

                            public void failed(Trace trace, Simulation simulation, Step step) {
                                System.out.println("\tFAILED: " + step);
                                failed.add(step);
                            }

                            public void stop(Trace trace, Simulation simulation) {
                            }
                        };
                        simulator.addSimulationListener(l);
                        simulator.simulate((SimulatorContext)context, trace);
                        simulator.removeSimulationListener(l);
                        if (failed.size() > 0) {
                            ret = false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ret = false;
                    }
                }
            } else if (location.isDirectory()) {
                File child;
                File[] arr$ = location.listFiles();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (ret = this.simulate(child = arr$[i$])); ++i$) {
                }
            }
        }
        return ret;
    }
}

