/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model.local;

import java.util.List;
import java.util.Vector;
import org.scribble.protocol.model.Parameter;
import org.scribble.protocol.model.RoleInstantiation;
import org.scribble.protocol.model.local.LActivity;
import org.scribble.protocol.model.local.LVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LCreate
extends LActivity {
    private String _protocol = null;
    private List<Parameter> _parameters = new Vector<Parameter>();
    private List<RoleInstantiation> _roleInstantiations = new Vector<RoleInstantiation>();

    public LCreate() {
    }

    public LCreate(LCreate copy) {
        super(copy);
        this._protocol = copy.getProtocol();
        for (Parameter p : copy.getParameters()) {
            this._parameters.add(new Parameter(p));
        }
        for (RoleInstantiation ri : copy.getRoleInstantiations()) {
            this._roleInstantiations.add(new RoleInstantiation(ri));
        }
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public List<Parameter> getParameters() {
        return this._parameters;
    }

    public List<RoleInstantiation> getRoleInstantiations() {
        return this._roleInstantiations;
    }

    @Override
    public void visit(LVisitor visitor) {
        visitor.accept(this);
    }

    @Override
    public void toText(StringBuffer buf, int level) {
        int i;
        this.indent(buf, level);
        buf.append("create ");
        buf.append(this._protocol);
        if (this._parameters.size() > 0) {
            buf.append('<');
            for (i = 0; i < this._parameters.size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                this._parameters.get(i).toText(buf, level);
            }
            buf.append(">");
        }
        buf.append("(");
        for (i = 0; i < this._roleInstantiations.size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            this._roleInstantiations.get(i).toText(buf, level);
        }
        buf.append(");\n");
    }
}

