/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model.global;

import java.util.List;
import java.util.Vector;
import org.scribble.protocol.model.FullyQualifiedName;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.RoleInstantiation;
import org.scribble.protocol.model.global.GActivity;
import org.scribble.protocol.model.global.GVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDo
extends GActivity {
    private String _protocol = null;
    private FullyQualifiedName _moduleName = null;
    private List<MessageSignature> _arguments = new Vector<MessageSignature>();
    private List<RoleInstantiation> _roleInstantiations = new Vector<RoleInstantiation>();

    public GDo() {
    }

    public GDo(GDo copy) {
        super(copy);
        this._protocol = copy.getProtocol();
        for (MessageSignature arg : copy.getArguments()) {
            this._arguments.add(new MessageSignature(arg));
        }
        for (RoleInstantiation ri : copy.getRoleInstantiations()) {
            this._roleInstantiations.add(new RoleInstantiation(ri));
        }
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public FullyQualifiedName getModuleName() {
        return this._moduleName;
    }

    public void setModuleName(FullyQualifiedName module) {
        this._moduleName = module;
    }

    public List<MessageSignature> getArguments() {
        return this._arguments;
    }

    public List<RoleInstantiation> getRoleInstantiations() {
        return this._roleInstantiations;
    }

    @Override
    public void visit(GVisitor visitor) {
        visitor.accept(this);
    }

    @Override
    public void toText(StringBuffer buf, int level) {
        int i;
        this.indent(buf, level);
        buf.append("do ");
        if (this._moduleName != null) {
            this._moduleName.toText(buf, level);
            buf.append(".");
        }
        buf.append(this._protocol);
        if (this._arguments.size() > 0) {
            buf.append('<');
            for (i = 0; i < this._arguments.size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(this._arguments.get(i));
            }
            buf.append(">");
        }
        buf.append("(");
        for (i = 0; i < this._roleInstantiations.size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            this._roleInstantiations.get(i).toText(buf, level);
        }
        buf.append(");\n");
    }
}

