/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.ArrayList;
import java.util.List;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.PayloadType;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageSignature
extends ModelObject {
    private String _operator = null;
    private List<PayloadType> _types = new ArrayList<PayloadType>();

    public MessageSignature() {
    }

    public MessageSignature(String operator, List<PayloadType> types) {
        this._operator = operator;
        this._types.addAll(types);
    }

    public MessageSignature(MessageSignature msig) {
        super(msig);
        this._operator = msig.getOperator();
        for (PayloadType tref : msig.getTypes()) {
            this._types.add(new PayloadType(tref));
        }
    }

    public String getOperator() {
        return this._operator;
    }

    public void setOperator(String operator) {
        this._operator = operator;
    }

    public List<PayloadType> getTypes() {
        return this._types;
    }

    public int hashCode() {
        int result = 13;
        result = 31 * result + this._types.hashCode();
        result = 31 * result + (this._operator == null ? 0 : this._operator.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        MessageSignature other;
        boolean ret = false;
        if (obj instanceof MessageSignature && (other = (MessageSignature)obj).getTypes().size() == this.getTypes().size()) {
            if (other._operator != null && this._operator != null) {
                ret = other._operator.equals(this._operator);
            } else if (other._operator == null && this._operator == null) {
                ret = true;
            }
            for (int i = 0; ret && i < this.getTypes().size(); ++i) {
                ret = this.getTypes().get(i).equals(other.getTypes().get(i));
            }
        }
        return ret;
    }

    public String toString() {
        String ret = "";
        if (this.getOperator() != null && this.getOperator().trim().length() > 0) {
            ret = ret + this.getOperator() + "(";
        }
        for (int i = 0; i < this._types.size(); ++i) {
            if (i > 0) {
                ret = ret + ",";
            }
            ret = ret + this._types.get(i).getType();
        }
        if (this.getOperator() != null && this.getOperator().trim().length() > 0) {
            ret = ret + ")";
        }
        if (ret.equals("")) {
            ret = "<No Signature>";
        }
        return ret;
    }

    @Override
    public void visit(Visitor visitor) {
    }

    @Override
    public void toText(StringBuffer buf, int level) {
        if (this._operator != null) {
            buf.append(this._operator);
            buf.append('(');
        }
        for (int i = 0; i < this.getTypes().size(); ++i) {
            if (i > 0) {
                buf.append(',');
            }
            this.getTypes().get(i).toText(buf, level);
        }
        if (this._operator != null) {
            buf.append(')');
        }
    }
}

