/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.command.osgi;

import java.util.Dictionary;
import java.util.Properties;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.scribble.command.Command;
import org.scribble.command.conforms.ConformsCommand;
import org.scribble.command.parse.ParseCommand;
import org.scribble.command.project.ProjectCommand;
import org.scribble.command.simulate.SimulateCommand;
import org.scribble.command.validate.ValidateCommand;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.conformance.ProtocolConformer;
import org.scribble.protocol.export.ProtocolExportManager;
import org.scribble.protocol.monitor.ProtocolMonitor;
import org.scribble.protocol.parser.ProtocolParserManager;
import org.scribble.protocol.projection.ProtocolProjector;
import org.scribble.protocol.validation.ProtocolValidationManager;

public class Activator
implements BundleActivator {
    public void start(final BundleContext context) {
        final Commands commands = new Commands();
        Properties props = new Properties();
        commands.setParseCommand(new ParseCommand());
        context.registerService(Command.class.getName(), (Object)commands.getParseCommand(), (Dictionary)props);
        commands.setValidateCommand(new ValidateCommand());
        context.registerService(Command.class.getName(), (Object)commands.getValidateCommand(), (Dictionary)props);
        commands.setConformsCommand(new ConformsCommand());
        context.registerService(Command.class.getName(), (Object)commands.getConformsCommand(), (Dictionary)props);
        commands.setProjectCommand(new ProjectCommand());
        context.registerService(Command.class.getName(), (Object)commands.getProjectCommand(), (Dictionary)props);
        commands.setSimulateCommand(new SimulateCommand());
        context.registerService(Command.class.getName(), (Object)commands.getSimulateCommand(), (Dictionary)props);
        ServiceListener[] sl = new ServiceListener[]{new ServiceListener(){

            public void serviceChanged(ServiceEvent ev) {
                ServiceReference sr = ev.getServiceReference();
                switch (ev.getType()) {
                    case 1: {
                        ProtocolValidationManager vm = (ProtocolValidationManager)context.getService(sr);
                        commands.setProtocolValidationManager(vm);
                        break;
                    }
                }
            }
        }, new ServiceListener(){

            public void serviceChanged(ServiceEvent ev) {
                ServiceReference sr = ev.getServiceReference();
                switch (ev.getType()) {
                    case 1: {
                        Journal journal = (Journal)context.getService(sr);
                        commands.setJournal(journal);
                        break;
                    }
                }
            }
        }, new ServiceListener(){

            public void serviceChanged(ServiceEvent ev) {
                ServiceReference sr = ev.getServiceReference();
                switch (ev.getType()) {
                    case 1: {
                        ProtocolParserManager pp = (ProtocolParserManager)context.getService(sr);
                        commands.setProtocolParserManager(pp);
                        break;
                    }
                }
            }
        }, new ServiceListener(){

            public void serviceChanged(ServiceEvent ev) {
                ServiceReference sr = ev.getServiceReference();
                switch (ev.getType()) {
                    case 1: {
                        ProtocolConformer conformer = (ProtocolConformer)context.getService(sr);
                        commands.setProtocolConformer(conformer);
                        break;
                    }
                }
            }
        }, new ServiceListener(){

            public void serviceChanged(ServiceEvent ev) {
                ServiceReference sr = ev.getServiceReference();
                switch (ev.getType()) {
                    case 1: {
                        ProtocolProjector projector = (ProtocolProjector)context.getService(sr);
                        commands.setProtocolProjector(projector);
                        break;
                    }
                }
            }
        }, new ServiceListener(){

            public void serviceChanged(ServiceEvent ev) {
                ServiceReference sr = ev.getServiceReference();
                switch (ev.getType()) {
                    case 1: {
                        ProtocolExportManager em = (ProtocolExportManager)context.getService(sr);
                        commands.setProtocolExportManager(em);
                        break;
                    }
                }
            }
        }, new ServiceListener(){

            public void serviceChanged(ServiceEvent ev) {
                ServiceReference sr = ev.getServiceReference();
                switch (ev.getType()) {
                    case 1: {
                        ProtocolMonitor pm = (ProtocolMonitor)context.getService(sr);
                        commands.setProtocolMonitor(pm);
                        break;
                    }
                }
            }
        }};
        this.initCommands(context, commands, sl);
    }

    protected void initCommands(BundleContext context, Commands commands, ServiceListener[] sl) {
        String filter1 = "(objectclass=" + ProtocolValidationManager.class.getName() + ")";
        String filter2 = "(objectclass=" + Journal.class.getName() + ")";
        String filter3 = "(objectclass=" + ProtocolParserManager.class.getName() + ")";
        String filter4 = "(objectclass=" + ProtocolConformer.class.getName() + ")";
        String filter5 = "(objectclass=" + ProtocolProjector.class.getName() + ")";
        String filter6 = "(objectclass=" + ProtocolExportManager.class.getName() + ")";
        String filter7 = "(objectclass=" + ProtocolMonitor.class.getName() + ")";
        try {
            ServiceReference sref = context.getServiceReference(ProtocolValidationManager.class.getName());
            ProtocolValidationManager pvm = null;
            if (sref != null) {
                pvm = (ProtocolValidationManager)context.getService(sref);
            }
            if (pvm != null) {
                commands.setProtocolValidationManager(pvm);
            } else {
                context.addServiceListener(sl[0], filter1);
            }
            sref = context.getServiceReference(Journal.class.getName());
            Journal journal = null;
            if (sref != null) {
                journal = (Journal)context.getService(sref);
            }
            if (journal != null) {
                commands.setJournal(journal);
            } else {
                context.addServiceListener(sl[1], filter2);
            }
            sref = context.getServiceReference(ProtocolParserManager.class.getName());
            ProtocolParserManager pp = null;
            if (sref != null) {
                pp = (ProtocolParserManager)context.getService(sref);
            }
            if (pp != null) {
                commands.setProtocolParserManager(pp);
            } else {
                context.addServiceListener(sl[2], filter3);
            }
            sref = context.getServiceReference(ProtocolConformer.class.getName());
            ProtocolConformer pc = null;
            if (sref != null) {
                pc = (ProtocolConformer)context.getService(sref);
            }
            if (pc != null) {
                commands.setProtocolConformer(pc);
            } else {
                context.addServiceListener(sl[3], filter4);
            }
            sref = context.getServiceReference(ProtocolProjector.class.getName());
            ProtocolProjector ppj = null;
            if (sref != null) {
                ppj = (ProtocolProjector)context.getService(sref);
            }
            if (ppj != null) {
                commands.setProtocolProjector(ppj);
            } else {
                context.addServiceListener(sl[4], filter5);
            }
            sref = context.getServiceReference(ProtocolExportManager.class.getName());
            ProtocolExportManager pem = null;
            if (sref != null) {
                pem = (ProtocolExportManager)context.getService(sref);
            }
            if (pem != null) {
                commands.setProtocolExportManager(pem);
            } else {
                context.addServiceListener(sl[5], filter6);
            }
            sref = context.getServiceReference(ProtocolMonitor.class.getName());
            ProtocolMonitor pm = null;
            if (sref != null) {
                pm = (ProtocolMonitor)context.getService(sref);
            }
            if (pm != null) {
                commands.setProtocolMonitor(pm);
            } else {
                context.addServiceListener(sl[6], filter7);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop(BundleContext context) {
    }

    protected class Commands {
        private ParseCommand _parseCommand = null;
        private ValidateCommand _validateCommand = null;
        private ConformsCommand _conformsCommand = null;
        private ProjectCommand _projectCommand = null;
        private SimulateCommand _simulateCommand = null;

        protected Commands() {
        }

        public void setProtocolValidationManager(ProtocolValidationManager vm) {
            this._validateCommand.setValidationManager(vm);
        }

        public void setJournal(Journal journal) {
            this._parseCommand.setJournal(journal);
            this._validateCommand.setJournal(journal);
            this._conformsCommand.setJournal(journal);
            this._projectCommand.setJournal(journal);
            this._simulateCommand.setJournal(journal);
        }

        public void setProtocolParserManager(ProtocolParserManager pp) {
            this._parseCommand.setProtocolParserManager(pp);
            this._validateCommand.setProtocolParserManager(pp);
            this._conformsCommand.setProtocolParserManager(pp);
            this._projectCommand.setProtocolParserManager(pp);
            this._simulateCommand.setProtocolParserManager(pp);
        }

        public void setProtocolConformer(ProtocolConformer pc) {
            this._conformsCommand.setConformer(pc);
        }

        public void setProtocolProjector(ProtocolProjector pp) {
            this._projectCommand.setProtocolProjector(pp);
        }

        public void setProtocolExportManager(ProtocolExportManager em) {
            this._projectCommand.setProtocolExportManager(em);
            this._simulateCommand.setProtocolExportManager(em);
        }

        public void setProtocolMonitor(ProtocolMonitor pm) {
            this._simulateCommand.setProtocolMonitor(pm);
        }

        public void setParseCommand(ParseCommand command) {
            this._parseCommand = command;
        }

        public ParseCommand getParseCommand() {
            return this._parseCommand;
        }

        public void setValidateCommand(ValidateCommand command) {
            this._validateCommand = command;
        }

        public ValidateCommand getValidateCommand() {
            return this._validateCommand;
        }

        public void setConformsCommand(ConformsCommand command) {
            this._conformsCommand = command;
        }

        public ConformsCommand getConformsCommand() {
            return this._conformsCommand;
        }

        public void setProjectCommand(ProjectCommand command) {
            this._projectCommand = command;
        }

        public ProjectCommand getProjectCommand() {
            return this._projectCommand;
        }

        public void setSimulateCommand(SimulateCommand command) {
            this._simulateCommand = command;
        }

        public SimulateCommand getSimulateCommand() {
            return this._simulateCommand;
        }
    }
}

