/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.command.project;

import java.io.File;
import java.io.OutputStream;
import org.scribble.command.Command;
import org.scribble.common.logging.Journal;
import org.scribble.common.resource.Content;
import org.scribble.common.resource.DefaultResourceLocator;
import org.scribble.common.resource.FileContent;
import org.scribble.common.resource.ResourceLocator;
import org.scribble.protocol.DefaultProtocolContext;
import org.scribble.protocol.ProtocolContext;
import org.scribble.protocol.export.ProtocolExportManager;
import org.scribble.protocol.export.ProtocolExporter;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.parser.ProtocolParserManager;
import org.scribble.protocol.projection.ProtocolProjector;

public class ProjectCommand
implements Command {
    private Journal m_journal = null;
    private ProtocolParserManager m_protocolParserManager = null;
    private ProtocolProjector m_protocolProjector = null;
    private ProtocolExportManager m_protocolExportManager = null;

    public void setJournal(Journal journal) {
        this.m_journal = journal;
    }

    public void setProtocolParserManager(ProtocolParserManager parser) {
        this.m_protocolParserManager = parser;
    }

    public void setProtocolProjector(ProtocolProjector projector) {
        this.m_protocolProjector = projector;
    }

    public void setProtocolExportManager(ProtocolExportManager exportManager) {
        this.m_protocolExportManager = exportManager;
    }

    public String getName() {
        return "project";
    }

    public String getDescription() {
        return "Project a global protocol description to a role's local model";
    }

    public boolean execute(String[] args) {
        boolean ret = false;
        if (args.length == 2) {
            this.m_journal.info("PROJECT " + args[0] + " for role " + args[1], null);
            File f = new File(args[0]);
            if (!f.exists()) {
                this.m_journal.error("File not found '" + args[0] + "'", null);
            } else {
                ProtocolModel model = null;
                try {
                    FileContent content = new FileContent(f);
                    model = this.m_protocolParserManager.parse((Content)content, this.m_journal, (ProtocolContext)new DefaultProtocolContext(this.m_protocolParserManager, (ResourceLocator)new DefaultResourceLocator(f.getParentFile())));
                }
                catch (Exception e) {
                    this.m_journal.error("Failed to parse file '" + args[0] + "'", null);
                }
                if (model != null) {
                    Role role = new Role(args[1]);
                    try {
                        ProtocolExporter exporter;
                        ProtocolModel projection = this.m_protocolProjector.project(model, role, this.m_journal, (ProtocolContext)new DefaultProtocolContext(this.m_protocolParserManager, (ResourceLocator)new DefaultResourceLocator(f.getParentFile())));
                        if (projection != null && (exporter = this.m_protocolExportManager.getExporter("txt")) != null) {
                            exporter.export(projection, this.m_journal, (OutputStream)System.out);
                            ret = true;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            this.m_journal.error("Projection expects 2 parameters", null);
        }
        return ret;
    }
}

